/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference.elements;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.lang.inspections.deadcode.local.PhpUnusedSymbolsFilterVisitor;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMember;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMemberImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefField;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefUtil;
import com.jetbrains.php.lang.inspections.reference.visitors.PhpRefVisitor;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRefFieldImpl
extends PhpRefClassMemberImpl
implements PhpRefField {
    private static final int USED_FOR_READING_MASK = 65536;
    private static final int USED_FOR_WRITING_MASK = 131072;
    private static final int ASSIGNED_ONLY_IN_INITIALIZER_MASK = 262144;
    @Nullable
    private Set<PhpRefField> mySuperFields;
    @Nullable
    private Set<PhpRefField> myDerivedFields;
    @Nullable
    private PhpRefField myMirrorField;

    public PhpRefFieldImpl(@NotNull PhpRefClass refClass, @NotNull Field psi, @NotNull RefManager manager) {
        if (refClass == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(0);
        }
        if (psi == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(2);
        }
        super(refClass, (PhpClassMember)psi, manager);
    }

    @Override
    protected void initialize() {
        this.appendDirectSuperMembers(PhpRefFieldImpl.class, superRefField -> this.attachSuperField((PhpRefFieldImpl)((Object)superRefField)));
    }

    void attachSuperField(PhpRefFieldImpl superRefField) {
        this.addOverlappedField(superRefField);
        superRefField.markFieldOverlap(this);
    }

    @Nullable
    public Field getPhpElement() {
        return super.getPhpElement(Field.class);
    }

    @NotNull
    public Collection<? extends PhpRefClassMember> getDerivedMembers() {
        Collection<PhpRefField> collection = this.getDerivedFields();
        if (collection == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends PhpRefClassMember> getSuperMembers() {
        Collection<PhpRefField> collection = this.getSuperFields();
        if (collection == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    public void buildReferences() {
        super.buildReferences();
        Field field = this.getPhpElement();
        if (field == null) {
            return;
        }
        PhpRefUtil.attachTypeToDeclaration(field.getType(), (PhpPsiElement)field, this);
        this.bindMirrorField(field);
        PsiElement defaultValue = field.getDefaultValue();
        if (defaultValue == null) {
            return;
        }
        PhpRefUtil.addReferencesTo((PhpPsiElement)field, (RefElement)this, defaultValue);
    }

    private void bindMirrorField(@NotNull Field field) {
        RefElement mirrorFieldRef;
        if (field == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(5);
        }
        if ((mirrorFieldRef = PhpRefUtil.getReferenceEx((PsiElement)PhpUnusedSymbolsFilterVisitor.getMirror(field), this.getRefManager())) instanceof PhpRefFieldImpl) {
            ((PhpRefFieldImpl)mirrorFieldRef).setMirror(this);
        }
    }

    public boolean isConstant() {
        Field field = this.getPhpElement();
        return field != null && field.isConstant();
    }

    public boolean isForReading() {
        return this.checkFlag(65536L);
    }

    public void setForReading(boolean forReading) {
        this.setFlag(forReading, 65536L);
    }

    public boolean isForWriting() {
        return this.checkFlag(131072L);
    }

    public void setForWriting(boolean forWriting) {
        this.setFlag(forWriting, 131072L);
    }

    public boolean isOnlyAssignedInInitializer() {
        return this.checkFlag(262144L);
    }

    @NotNull
    public synchronized Collection<PhpRefField> getSuperFields() {
        Collection collection = (Collection)ObjectUtils.notNull(this.mySuperFields, Collections.emptySet());
        if (collection == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public synchronized Collection<PhpRefField> getDerivedFields() {
        Collection collection = (Collection)ObjectUtils.notNull(this.myDerivedFields, Collections.emptySet());
        if (collection == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public synchronized void addOverlappedField(PhpRefField refSuperField) {
        this.mySuperFields = this.addRefMemberTo(refSuperField, this.mySuperFields);
    }

    public synchronized void markFieldOverlap(PhpRefField refOverlappingField) {
        this.myDerivedFields = this.addRefMemberTo(refOverlappingField, this.myDerivedFields);
    }

    @Nullable
    public synchronized PhpRefField getRefMirror() {
        return this.myMirrorField;
    }

    public synchronized void setMirror(@NotNull PhpRefField fieldMirror) {
        if (fieldMirror == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(8);
        }
        this.myMirrorField = fieldMirror;
    }

    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(9);
        }
        if (visitor instanceof PhpRefVisitor) {
            ReadAction.run(() -> ((PhpRefVisitor)visitor).visitRefField(this));
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public void referenceRemoved() {
        super.referenceRemoved();
        PhpRefUtil.runOnCollection(this::removeSuper, this.getSuperFields().toArray(PhpRefField.EMPTY_FIELD_ARRAY));
    }

    private synchronized void removeSuper(@NotNull PhpRefField superField) {
        if (superField == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(10);
        }
        this.removeRefMemberFrom(this, superField.getDerivedFields());
        this.removeRefMemberFrom(superField, this.getSuperFields());
    }

    public void setAssignedOnlyInInitializer(boolean onlyInInitializer) {
        this.setFlag(onlyInInitializer, 262144L);
    }

    @Nullable
    public static RefEntity fieldFromExternalName(RefManagerImpl manager, String externalName) {
        List qualifiedPath = StringUtil.split((String)externalName, (String)" ");
        if (qualifiedPath.size() == 2) {
            PhpClass phpClass = PhpRefFieldImpl.classFromClassMemberExternalName(manager, qualifiedPath);
            return phpClass != null ? PhpRefUtil.getReferenceEx((PsiElement)ObjectUtils.chooseNotNull((Object)phpClass.findOwnFieldByName((CharSequence)qualifiedPath.get(1), false), (Object)phpClass.findOwnFieldByName((CharSequence)qualifiedPath.get(1), true)), manager) : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefFieldImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldMirror";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefFieldImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedMembers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperMembers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperFields";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindMirrorField";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeSuper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

