/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefConstant;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefField;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMembersToReportOptionsPanel
extends LocalInspectionTool
implements UnfairLocalInspectionTool {
    @NotNull
    @NonNls
    public static final String DEFAULT_VISIBILITY = PhpModifier.Access.PUBLIC.toString();
    @NotNull
    public static final PhpModifier.Access DEFAULT_ACCESS = PhpModifier.Access.PUBLIC;
    public boolean FIELD = true;
    public boolean CONST = true;
    public boolean METHOD = true;
    public boolean CLASS = true;
    public boolean FUNCTION = true;
    public boolean MAGIC_METHOD = true;
    protected String myConstVisibility = DEFAULT_VISIBILITY;
    protected String myFieldVisibility = DEFAULT_VISIBILITY;
    protected String myMethodVisibility = DEFAULT_VISIBILITY;

    public boolean isAccepted(@NotNull UserDataHolder element) {
        if (element == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(0);
        }
        if (element instanceof PhpClass || element instanceof PhpRefClass) {
            return this.CLASS;
        }
        if (element instanceof Method || element instanceof PhpRefMethod) {
            String name = element instanceof Method ? ((Method)element).getName() : ((PhpRefMethod)element).getName();
            return PhpLangUtil.isMagicMethod(name) ? this.MAGIC_METHOD : this.METHOD;
        }
        if (element instanceof Function || element instanceof PhpRefFunction) {
            return this.FUNCTION;
        }
        if (element instanceof Field || element instanceof PhpRefField) {
            boolean isConstant = element instanceof Field ? ((Field)element).isConstant() : ((PhpRefField)element).isConstant();
            return isConstant ? this.CONST : this.FIELD;
        }
        if (element instanceof Constant || element instanceof PhpRefConstant) {
            return this.CONST;
        }
        return true;
    }

    public boolean isComparableByVisibility(@Nullable UserDataHolder element) {
        return element instanceof Function || element instanceof PhpRefFunction || element instanceof Field || element instanceof PhpRefField;
    }

    @NotNull
    public PhpModifier.Access getAcceptedVisibility(@Nullable UserDataHolder element) {
        if (element instanceof Field || element instanceof PhpRefField) {
            boolean isConstant = element instanceof Field ? ((Field)element).isConstant() : ((PhpRefField)element).isConstant();
            PhpModifier.Access access = isConstant ? this.getConstVisibility() : this.getFieldVisibility();
            if (access == null) {
                PhpMembersToReportOptionsPanel.$$$reportNull$$$0(1);
            }
            return access;
        }
        if (element instanceof Method || element instanceof PhpRefMethod) {
            PhpModifier.Access access = this.getMethodVisibility();
            if (access == null) {
                PhpMembersToReportOptionsPanel.$$$reportNull$$$0(2);
            }
            return access;
        }
        PhpModifier.Access access = PhpModifier.Access.PUBLIC;
        if (access == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(3);
        }
        return access;
    }

    @NotNull
    public PhpModifier.Access getFieldVisibility() {
        PhpModifier.Access access = PhpChangeSignatureUsageProcessor.accessFromString(this.myFieldVisibility);
        if (access == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(4);
        }
        return access;
    }

    public void setFieldVisibility(@NotNull String fieldVisibility) {
        if (fieldVisibility == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(5);
        }
        this.myFieldVisibility = fieldVisibility;
    }

    @NotNull
    public PhpModifier.Access getMethodVisibility() {
        PhpModifier.Access access = PhpChangeSignatureUsageProcessor.accessFromString(this.myMethodVisibility);
        if (access == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(6);
        }
        return access;
    }

    public void setMethodVisibility(@NotNull String methodVisibility) {
        if (methodVisibility == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(7);
        }
        this.myMethodVisibility = methodVisibility;
    }

    @NotNull
    public PhpModifier.Access getConstVisibility() {
        PhpModifier.Access access = PhpChangeSignatureUsageProcessor.accessFromString(this.myConstVisibility);
        if (access == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(8);
        }
        return access;
    }

    public void setConstVisibility(@NotNull String constVisibility) {
        if (constVisibility == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(9);
        }
        this.myConstVisibility = constVisibility;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getPanel();
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "PhpUnused";
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "PhpUnused";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(10);
        }
        PhpMembersToReportOptionsPanel.writeVisibility(node, this.myFieldVisibility, "field_visibility");
        PhpMembersToReportOptionsPanel.writeVisibility(node, this.myMethodVisibility, "method_visibility");
        PhpMembersToReportOptionsPanel.writeVisibility(node, this.myConstVisibility, "const_visibility");
        super.writeSettings(node);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(11);
        }
        super.readSettings(node);
        this.myFieldVisibility = PhpMembersToReportOptionsPanel.readVisibility(node, "field_visibility");
        this.myMethodVisibility = PhpMembersToReportOptionsPanel.readVisibility(node, "method_visibility");
        this.myConstVisibility = PhpMembersToReportOptionsPanel.readVisibility(node, "const_visibility");
    }

    private static void writeVisibility(Element node, String visibility, String type) {
        if (!DEFAULT_VISIBILITY.equals(visibility)) {
            node.setAttribute(type, visibility);
        }
    }

    private static String readVisibility(@NotNull Element node, String type) {
        String visibility;
        if (node == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(12);
        }
        if ((visibility = node.getAttributeValue(type)) == null) {
            return DEFAULT_VISIBILITY;
        }
        return visibility;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/PhpMembersToReportOptionsPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldVisibility";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodVisibility";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constVisibility";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/PhpMembersToReportOptionsPanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedVisibility";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldVisibility";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodVisibility";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstVisibility";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAccepted";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFieldVisibility";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMethodVisibility";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setConstVisibility";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readVisibility";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JCheckBox myCheckFieldsCheckBox;
        private JCheckBox myCheckMethodsCheckBox;
        private JCheckBox myCheckConstCheckBox;
        private JPanel myPanel;
        private ComboBox myFieldVisibilityCb;
        private ComboBox myMethodVisibilityCb;
        private ComboBox myConstVisibilityCb;
        private JCheckBox myClassCheckBox;
        private JCheckBox myFunctionCheckBox;
        private JCheckBox myMagicMethodCheckBox;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myClassCheckBox.setSelected(PhpMembersToReportOptionsPanel.this.CLASS);
            this.myFunctionCheckBox.setSelected(PhpMembersToReportOptionsPanel.this.FUNCTION);
            this.myMagicMethodCheckBox.setSelected(PhpMembersToReportOptionsPanel.this.MAGIC_METHOD);
            this.myCheckFieldsCheckBox.setSelected(PhpMembersToReportOptionsPanel.this.FIELD);
            this.myCheckMethodsCheckBox.setSelected(PhpMembersToReportOptionsPanel.this.METHOD);
            this.myCheckConstCheckBox.setSelected(PhpMembersToReportOptionsPanel.this.CONST);
            this.updateVisibleState();
            this.addListenerToCheckboxes(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhpMembersToReportOptionsPanel.this.FIELD = OptionsPanel.this.myCheckFieldsCheckBox.isSelected();
                    PhpMembersToReportOptionsPanel.this.METHOD = OptionsPanel.this.myCheckMethodsCheckBox.isSelected();
                    PhpMembersToReportOptionsPanel.this.CONST = OptionsPanel.this.myCheckConstCheckBox.isSelected();
                    OptionsPanel.this.updateVisibleState();
                }
            }, this.myCheckFieldsCheckBox, this.myCheckMethodsCheckBox, this.myCheckConstCheckBox);
            this.addListenerToCheckboxes(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhpMembersToReportOptionsPanel.this.CLASS = OptionsPanel.this.myClassCheckBox.isSelected();
                    PhpMembersToReportOptionsPanel.this.FUNCTION = OptionsPanel.this.myFunctionCheckBox.isSelected();
                    PhpMembersToReportOptionsPanel.this.MAGIC_METHOD = OptionsPanel.this.myMagicMethodCheckBox.isSelected();
                }
            }, this.myClassCheckBox, this.myFunctionCheckBox, this.myMagicMethodCheckBox);
        }

        private void addListenerToCheckboxes(@NotNull ActionListener actionListener, JCheckBox ... checkBoxes) {
            if (actionListener == null) {
                OptionsPanel.$$$reportNull$$$0(0);
            }
            if (checkBoxes == null) {
                OptionsPanel.$$$reportNull$$$0(1);
            }
            StreamEx.of((Object[])checkBoxes).forEach(box -> box.addActionListener(actionListener));
        }

        private void updateVisibleState() {
            this.myFieldVisibilityCb.setVisible(PhpMembersToReportOptionsPanel.this.FIELD);
            this.myMethodVisibilityCb.setVisible(PhpMembersToReportOptionsPanel.this.METHOD);
            this.myConstVisibilityCb.setVisible(PhpMembersToReportOptionsPanel.this.CONST);
        }

        public JComponent getPanel() {
            return this.myPanel;
        }

        private void createUIComponents() {
            PhpMembersToReportOptionsPanel panel2 = PhpMembersToReportOptionsPanel.this;
            this.myFieldVisibilityCb = new ModifierComboBox((Consumer<? super String>)((Consumer)panel2::setFieldVisibility));
            this.myConstVisibilityCb = new ModifierComboBox((Consumer<? super String>)((Consumer)panel2::setConstVisibility));
            this.myMethodVisibilityCb = new ModifierComboBox((Consumer<? super String>)((Consumer)panel2::setMethodVisibility));
            @NlsSafe String fieldVisibility = ((PhpModifier.Access)ObjectUtils.notNull((Object)panel2.getFieldVisibility(), (Object)DEFAULT_ACCESS)).toString();
            this.myFieldVisibilityCb.setSelectedItem((Object)fieldVisibility);
            @NlsSafe String constVisibility = ((PhpModifier.Access)ObjectUtils.notNull((Object)panel2.getConstVisibility(), (Object)DEFAULT_ACCESS)).toString();
            this.myConstVisibilityCb.setSelectedItem((Object)constVisibility);
            @NlsSafe String methodVisibility = ((PhpModifier.Access)ObjectUtils.notNull((Object)panel2.getMethodVisibility(), (Object)DEFAULT_ACCESS)).toString();
            this.myMethodVisibilityCb.setSelectedItem((Object)methodVisibility);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "checkBoxes";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/reference/PhpMembersToReportOptionsPanel$OptionsPanel";
            objectArray[2] = "addListenerToCheckboxes";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JPanel jPanel;
            this.createUIComponents();
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, 2, false, false));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, new Dimension(-1, 30), new Dimension(-1, 30), new Dimension(-1, 30)));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            jPanel2.setAlignmentX(0.5f);
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 30), new Dimension(-1, 30), new Dimension(-1, 30)));
            this.myCheckFieldsCheckBox = jCheckBox3 = new JCheckBox();
            jCheckBox3.setMaximumSize(new Dimension(95, 18));
            jCheckBox3.setMinimumSize(new Dimension(95, 18));
            jCheckBox3.setPreferredSize(new Dimension(95, 18));
            jCheckBox3.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.symbol.check.fields"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 17;
            jPanel2.add((Component)jCheckBox3, gridBagConstraints);
            ComboBox comboBox = this.myFieldVisibilityCb;
            comboBox.setMaximumSize(new Dimension(105, 30));
            comboBox.setMinimumSize(new Dimension(105, 30));
            comboBox.setOpaque(false);
            comboBox.setPreferredSize(new Dimension(105, 30));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 0.9;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.anchor = 17;
            jPanel2.add((Component)comboBox, gridBagConstraints2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new GridBagLayout());
            jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 30), new Dimension(-1, 30), new Dimension(-1, 30)));
            this.myCheckMethodsCheckBox = jCheckBox2 = new JCheckBox();
            jCheckBox2.setMaximumSize(new Dimension(95, 18));
            jCheckBox2.setMinimumSize(new Dimension(95, 18));
            jCheckBox2.setPreferredSize(new Dimension(95, 18));
            jCheckBox2.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.symbol.check.methods"));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 0.1;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.anchor = 17;
            jPanel3.add((Component)jCheckBox2, gridBagConstraints3);
            ComboBox comboBox2 = this.myMethodVisibilityCb;
            comboBox2.setMaximumSize(new Dimension(105, 30));
            comboBox2.setMinimumSize(new Dimension(105, 30));
            comboBox2.setOpaque(false);
            comboBox2.setPreferredSize(new Dimension(105, 30));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 0.9;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.anchor = 17;
            jPanel3.add((Component)comboBox2, gridBagConstraints4);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridBagLayout());
            jPanel.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 30), new Dimension(-1, 30), new Dimension(-1, 30)));
            this.myCheckConstCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setMaximumSize(new Dimension(95, 18));
            jCheckBox.setMinimumSize(new Dimension(95, 18));
            jCheckBox.setPreferredSize(new Dimension(95, 18));
            jCheckBox.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.symbol.check.constants"));
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.weightx = 0.1;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.anchor = 17;
            jPanel4.add((Component)jCheckBox, gridBagConstraints5);
            ComboBox comboBox3 = this.myConstVisibilityCb;
            comboBox3.setMaximumSize(new Dimension(105, 30));
            comboBox3.setMinimumSize(new Dimension(105, 30));
            comboBox3.setOpaque(false);
            comboBox3.setPreferredSize(new Dimension(105, 30));
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 0.9;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.anchor = 17;
            jPanel4.add((Component)comboBox3, gridBagConstraints6);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new GridBagLayout());
            jPanel.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JBCheckBox jBCheckBox = new JBCheckBox();
            this.myClassCheckBox = jBCheckBox;
            jBCheckBox.setSelected(true);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.symbol.check.classes"));
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.anchor = 17;
            jPanel5.add((Component)jBCheckBox, gridBagConstraints7);
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new GridBagLayout());
            jPanel.add((Component)jPanel6, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JBCheckBox jBCheckBox2 = new JBCheckBox();
            this.myFunctionCheckBox = jBCheckBox2;
            jBCheckBox2.setSelected(true);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.symbol.check.functions"));
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.anchor = 17;
            jPanel6.add((Component)jBCheckBox2, gridBagConstraints8);
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout(new GridBagLayout());
            jPanel.add((Component)jPanel7, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JBCheckBox jBCheckBox3 = new JBCheckBox();
            this.myMagicMethodCheckBox = jBCheckBox3;
            jBCheckBox3.setSelected(true);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.symbol.check.magic_method"));
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.anchor = 17;
            jPanel7.add((Component)jBCheckBox3, gridBagConstraints9);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    public static class ModifierComboBox
    extends ComboBox<String> {
        ModifierComboBox(Consumer<? super String> stringConsumer) {
            StreamEx.of((Object[])PhpModifier.Access.values()).map(PhpModifier.Access::toString).forEach(arg_0 -> this.addItem(arg_0));
            @NlsSafe String access = PhpModifier.Access.PUBLIC.toString();
            this.setSelectedItem(access);
            this.addActionListener(action -> ObjectUtils.consumeIfCast((Object)this.getItemAt(this.getSelectedIndex()), String.class, (Consumer)stringConsumer));
        }
    }
}

