/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.type;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeReturnTypeQuickFix
extends PhpQuickFixBase {
    @NotNull
    private final PhpType myNewType;
    @NotNull
    private final String myTypePresentation;
    @NotNull
    private final String myCurrentTypePresentation;

    public PhpChangeReturnTypeQuickFix(Project project, @NotNull PhpType currentType, @NotNull PhpType newType) {
        if (currentType == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(0);
        }
        if (newType == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(1);
        }
        this.myNewType = newType;
        this.myCurrentTypePresentation = StringUtil.notNullize((String)PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, currentType, null));
        this.myTypePresentation = StringUtil.notNullize((String)PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, newType, null));
    }

    @Nls
    @NotNull
    public String getName() {
        String string = PhpBundle.message("quickfix.strict.type.checking.change.return.type.name", this.myCurrentTypePresentation, this.myTypePresentation);
        if (string == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.strict.type.checking.change.return.type.family", new Object[0]);
        if (string == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Function function;
        if (project == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(5);
        }
        if ((function = PhpChangeReturnTypeQuickFix.getFunctionByReturnStatement(descriptor.getPsiElement())) == null) {
            return;
        }
        PhpChangeReturnTypeQuickFix.changeReturnType(function, this.myNewType);
    }

    public static void changeReturnType(@NotNull Function function, @NotNull PhpType newType) {
        PhpDocComment phpDoc;
        PhpReturnType returnType;
        if (function == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(6);
        }
        if (newType == null) {
            PhpChangeReturnTypeQuickFix.$$$reportNull$$$0(7);
        }
        if ((returnType = (PhpReturnType)function.getTypeDeclaration()) != null) {
            returnType.update(newType);
        }
        if ((phpDoc = function.getDocComment()) != null) {
            PhpTypeDeclarationImpl.update((PhpDocTag)phpDoc.getReturnTag(), newType);
        }
    }

    @Nullable
    public static Function getFunctionByReturnStatement(@Nullable PsiElement element) {
        Condition stopAt = Conditions.or((Condition)PhpClass.INSTANCEOF, (Condition)PhpNamespace.INSTANCEOF);
        return (Function)PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)stopAt);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpChangeReturnTypeQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpChangeReturnTypeQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "changeReturnType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

