/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.type;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.inspections.phpdoc.PhpUpdateSignatureFromPhpDocQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpParameterInfo;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpChangeParameterTypeQuickFix
extends PhpQuickFixBase {
    private final int myIndex;
    private final PhpType myCurrentType;
    private final PhpType myNewType;
    private final boolean myIsOnTheFly;
    private final String myTypePresentation;
    private final String myCurrentTypePresentation;

    public PhpChangeParameterTypeQuickFix(Project project, int index, @NotNull PhpType currentType, @NotNull PhpType newType, boolean isOnTheFly) {
        if (currentType == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(0);
        }
        if (newType == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(1);
        }
        this.myIndex = index;
        this.myCurrentType = currentType;
        this.myNewType = newType;
        this.myIsOnTheFly = isOnTheFly;
        this.myCurrentTypePresentation = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, currentType, null);
        this.myTypePresentation = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, this.getNewTypeWithPreservedNullability(), null);
    }

    @Nls
    @NotNull
    public String getName() {
        String string = PhpBundle.message("quickfix.strict.type.checking.change.parameter.type.name", this.myIndex + 1, this.myCurrentTypePresentation, this.myTypePresentation);
        if (string == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.strict.type.checking.change.parameter.type.family", new Object[0]);
        if (string == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        NewExpression newExpression;
        if (project == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(5);
        }
        Object reference = (newExpression = (NewExpression)PhpPsiUtil.getParentByCondition(element = descriptor.getPsiElement(), true, (Condition<? super PsiElement>)NewExpression.INSTANCEOF, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF)) != null ? newExpression.getClassReference() : (PhpReference)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF);
        assert (reference != null);
        Function function = (Function)reference.resolve();
        assert (function != null);
        PhpUpdateSignatureFromPhpDocQuickFix.changeFunctionSignature(function, this.createChangeInfo(project, function), this.myIsOnTheFly);
    }

    @NotNull
    private PhpChangeInfo createChangeInfo(@NotNull Project project, @NotNull Function function) {
        PhpMethodDescriptor functionDescriptor;
        List<com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo> parameterInfos;
        if (project == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(6);
        }
        if (function == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(7);
        }
        com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo parameterToChange = parameterInfos.get(this.myIndex < (parameterInfos = (functionDescriptor = new PhpMethodDescriptor(function)).getParameters()).size() ? this.myIndex : parameterInfos.size() - 1);
        assert (this.myIndex < parameterInfos.size() || parameterToChange.isVariadic());
        PhpType newType = this.getNewTypeWithPreservedNullability();
        parameterToChange.setType(newType, this.createTypeText(project, newType, (PhpPsiElement)function, parameterToChange));
        return new PhpChangeInfo(functionDescriptor, parameterInfos.toArray(new com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo[0]), functionDescriptor.getVisibility(), functionDescriptor.getName(), functionDescriptor.getReturnTypeText(), null, false, true);
    }

    @NotNull
    private String createTypeText(@NotNull Project project, @NotNull PhpType newType, @NotNull PhpPsiElement scope, @NotNull com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo parameterInfo) {
        if (project == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(8);
        }
        if (newType == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(10);
        }
        if (parameterInfo == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(11);
        }
        PhpParameterInfo bridgeParamInfo = new PhpParameterInfo(parameterInfo.getName(), newType.filterNull().getTypes(), newType.isNullable());
        String string = PhpAddMethodDeclarationQuickFix.createParameterTypeHint(project, bridgeParamInfo, scope, false, PhpLanguageFeature.UNION_TYPES.isSupported(project));
        if (string == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private PhpType getNewTypeWithPreservedNullability() {
        if (PhpType.NULL.equals((Object)this.myNewType)) {
            PhpType phpType = new PhpType().add(this.myCurrentType).add(PhpType.NULL);
            if (phpType == null) {
                PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(13);
            }
            return phpType;
        }
        PhpType phpType = this.myCurrentType.isNullable() || this.myNewType.isNullable() ? new PhpType().add(this.myNewType).add(PhpType.NULL) : this.myNewType;
        if (phpType == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(14);
        }
        return phpType;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpChangeParameterTypeQuickFix";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpChangeParameterTypeQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewTypeWithPreservedNullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createChangeInfo";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTypeText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

