/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.type;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeFieldTypeToMatchSuperQuickFix
extends PhpQuickFixBase {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpChangeFieldTypeToMatchSuperQuickFix.getFixName();
        if (string == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Field field;
        if (project == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(2);
        }
        if ((field = PhpChangeFieldTypeToMatchSuperQuickFix.getTargetField(descriptor.getStartElement())) == null) {
            return;
        }
        Field superField = PhpHierarchyChecksInspection.findDeepestSuperField(field);
        if (superField == null) {
            return;
        }
        field.updateType(superField.getDeclaredType().global(project));
    }

    @Nullable
    static Field getTargetField(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof Field) {
            return (Field)parent;
        }
        return (Field)PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)Field.INSTANCEOF);
    }

    @Nullable
    public static String getDeclaredTypeString(@NotNull Project project, @NotNull PhpType declaredType, @Nullable PsiElement element) {
        if (project == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(3);
        }
        if (declaredType == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(4);
        }
        if (declaredType.getTypes().contains("\\false") && declaredType.size() == 1) {
            return PhpType.BOOLEAN.toString();
        }
        boolean isNullable = declaredType.isNullable();
        if (isNullable && declaredType.size() == 1) {
            return null;
        }
        Collection<String> normalizedTypes = PhpChangeFieldTypeToMatchSuperQuickFix.getNormalizedTypeStrings(project, declaredType, element);
        boolean unionTypesSupported = PhpLanguageFeature.UNION_TYPES.isSupported(project);
        if (normalizedTypes.isEmpty() || normalizedTypes.size() == 2 && !isNullable && !unionTypesSupported || normalizedTypes.size() > 2 && !unionTypesSupported) {
            return null;
        }
        if (normalizedTypes.size() == 2 && isNullable) {
            return "?" + (String)ContainerUtil.getFirstItem((List)ContainerUtil.filter(normalizedTypes, ts -> !PhpType.isNull((String)PhpLangUtil.toFQN(ts))));
        }
        return StringUtil.join(normalizedTypes, (String)"|");
    }

    @NotNull
    private static Collection<String> getNormalizedTypeStrings(@NotNull Project project, @NotNull PhpType declaredType, @Nullable PsiElement element) {
        boolean hasSelf;
        if (project == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(5);
        }
        if (declaredType == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(6);
        }
        PhpType declaredTypeWithoutSelf = declaredType.filterOut(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.SELF_CLASS).isSigned(arg_0));
        PhpType globalType = declaredTypeWithoutSelf.global(project).filterUnknown();
        List normalizedTypes = ((StreamEx)StreamEx.of((Collection)globalType.getTypes()).map(t -> PhpType.isPluralType((String)t) ? "\\array" : t).distinct()).map(t -> PhpChangeFieldTypeToMatchSuperQuickFix.getNormalizedTypeString(t, element)).toList();
        boolean bl = hasSelf = declaredTypeWithoutSelf.size() != declaredType.size();
        if (hasSelf) {
            List list = ContainerUtil.append((List)normalizedTypes, (Object[])new String[]{"self"});
            if (list == null) {
                PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = normalizedTypes;
        if (list == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static String getNormalizedTypeString(@NotNull String typeString, @Nullable PsiElement element) {
        if (typeString == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(9);
        }
        typeString = PhpType.toString((String)typeString);
        if (element == null) {
            String string = typeString;
            if (string == null) {
                PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(10);
            }
            return string;
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(element);
        String string = scope != null && PhpLangUtil.isFqn(typeString) ? PhpCodeInsightUtil.createQualifiedName(scope, typeString) : typeString;
        if (string == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nls
    public static String getFixName() {
        return PhpBundle.message("quickfix.change.field.type.to.match.super", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpChangeFieldTypeToMatchSuperQuickFix";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpChangeFieldTypeToMatchSuperQuickFix";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeStrings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredTypeString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeStrings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

