/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.type;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddInferredTypeAsPropertyTypeQuickFix
extends PhpQuickFixBase {
    private final PhpType myInferredType;
    private final String myTypeStr;
    private final boolean myIsOnTheFly;

    public PhpAddInferredTypeAsPropertyTypeQuickFix(@NotNull PhpType type, @NotNull String typeStr, boolean isOnTheFly) {
        if (type == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(0);
        }
        if (typeStr == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(1);
        }
        this.myTypeStr = typeStr;
        this.myInferredType = type;
        this.myIsOnTheFly = isOnTheFly;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = PhpBundle.message("quickfix.change.field.type.add.inferred.type.name", this.myTypeStr);
        if (string == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.change.field.type.add.inferred.type.family.name", new Object[0]);
        if (string == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Field field;
        if (project == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(5);
        }
        if ((field = PhpChangeFieldTypeToMatchSuperQuickFix.getTargetField(descriptor.getStartElement())) != null) {
            if (field.getDeclaredType().equals((Object)this.myInferredType)) {
                return;
            }
            List<Field> fieldsInHierarchy = PhpAddInferredTypeAsPropertyTypeQuickFix.getFieldsInHierarchy(field);
            String error = PhpAddInferredTypeAsPropertyTypeQuickFix.validateElementsChange(fieldsInHierarchy);
            if (error == null) {
                fieldsInHierarchy.forEach(f -> f.updateType(this.myInferredType));
            } else if (this.myIsOnTheFly) {
                PhpAddInferredTypeAsPropertyTypeQuickFix.showErrorMessage(project, error, (PsiElement)field);
            }
        }
    }

    @NotNull
    private static List<Field> getFieldsInHierarchy(Field field) {
        SmartList fieldsInHierarchy = new SmartList();
        fieldsInHierarchy.add(field);
        if (!field.getModifier().isPrivate()) {
            PhpClassHierarchyUtils.processOverridingFields((Field)field, (arg_0, arg_1, arg_2) -> PhpAddInferredTypeAsPropertyTypeQuickFix.lambda$getFieldsInHierarchy$1((List)fieldsInHierarchy, arg_0, arg_1, arg_2));
            PhpClassHierarchyUtils.processSuperFields((Field)field, (arg_0, arg_1, arg_2) -> PhpAddInferredTypeAsPropertyTypeQuickFix.lambda$getFieldsInHierarchy$2((List)fieldsInHierarchy, arg_0, arg_1, arg_2));
        }
        SmartList smartList = fieldsInHierarchy;
        if (smartList == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    public static boolean canApplyFix(@NotNull Field field) {
        if (field == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(7);
        }
        return ContainerUtil.all(PhpAddInferredTypeAsPropertyTypeQuickFix.getFieldsInHierarchy(field), f -> f.getManager().isInProject((PsiElement)f));
    }

    @Nullable
    @NlsContexts.HintText
    private static String validateElementsChange(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(8);
        }
        for (PsiElement psiElement : elements) {
            if (!psiElement.isWritable()) {
                return PhpBundle.message("quickfix.change.field.type.add.inferred.type.error.read.only", psiElement.getContainingFile().getName());
            }
            if (psiElement.getManager().isInProject(psiElement)) continue;
            return PhpBundle.message("quickfix.change.field.type.add.inferred.type.error.non.project", psiElement.getContainingFile().getName());
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$getFieldsInHierarchy$2(List fieldsInHierarchy, Field member, PhpClass subClass, PhpClass baseClass) {
        fieldsInHierarchy.add(member);
        return true;
    }

    private static /* synthetic */ boolean lambda$getFieldsInHierarchy$1(List fieldsInHierarchy, Field superMember, PhpClass subClass, PhpClass baseClass) {
        fieldsInHierarchy.add(superMember);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeStr";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpAddInferredTypeAsPropertyTypeQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpAddInferredTypeAsPropertyTypeQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsInHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canApplyFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateElementsChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

