/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.createClass;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.actions.PhpNewClassDataProvider;
import com.jetbrains.php.actions.PhpNewClassDialog;
import com.jetbrains.php.actions.PhpNewClassMockDataProvider;
import com.jetbrains.php.actions.newClassDataProvider.ClassCreationType;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseImportQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportClassQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpParameterInfo;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.intentions.generators.PhpConstructorGenerator;
import com.jetbrains.php.lang.intentions.generators.PhpInvalidTemplateException;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.refactoring.PhpFileCreator;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import com.jetbrains.php.roots.PhpDirectoryProvider;
import com.jetbrains.php.roots.PhpPsrNamespaceRootDetector;
import com.jetbrains.php.templates.PhpFileTemplateUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCreateClassQuickFix
extends PhpQuickFixBase {
    private static final String SEPARATOR = "/";
    public static final LocalQuickFix INSTANCE = new PhpCreateClassQuickFix();
    public static final LocalQuickFix LOW_PRIORITY_INSTANCE = new PhpCreateClassLowPriority();

    @NotNull
    public String getFamilyName() {
        String string = PhpCreateClassQuickFix.getNameText();
        if (string == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Editor editor;
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(2);
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile containingFile = psiElement.getContainingFile();
        PhpReference classReference = (PhpReference)PhpPsiUtil.getParentByCondition(psiElement, (Condition<? super PsiElement>)((Condition)psiElement1 -> psiElement1 instanceof ClassReference || psiElement1 instanceof PhpDocType));
        if (psiElement instanceof ClassReference) {
            classReference = (ClassReference)psiElement;
        }
        PsiFile file = null;
        if (classReference != null) {
            NewExpression expression = null;
            if (!PhpCreateClassQuickFix.isReferenceToInterface(classReference) && !PhpCreateClassQuickFix.isClassReferenceToTrait(classReference)) {
                NewExpression newExpression = (NewExpression)PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)NewExpression.INSTANCEOF);
                expression = newExpression != null ? newExpression : (PhpExpression)PhpPsiUtil.getParentByCondition((PsiElement)classReference, false, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF);
            }
            file = PhpCreateClassQuickFix.separateFile(project, classReference, expression, descriptor, PhpCreateClassQuickFix.getDataProvider(project, classReference, containingFile));
        }
        if ((editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) != null) {
            PhpDocComment docComment;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.doPostponedOperationsAndUnblockDocument(editor.getDocument());
            PhpClass clazz = (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)file, PhpClass.class, (boolean)false);
            PhpDocComment phpDocComment = docComment = clazz != null ? clazz.getDocComment() : null;
            if (docComment != null) {
                WriteCommandAction.runWriteCommandAction((Project)project, (String)PhpBundle.message("create.new.class.quickfix", new Object[0]), null, () -> PhpDocCommentGenerator.tryMoveCaretOnMarker(editor, docComment.getTextRange()), (PsiFile[])new PsiFile[0]);
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected static void resolveImports(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PhpReference phpReference;
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(4);
        }
        if ((phpReference = PhpBaseImportQuickFix.getReference(descriptor.getPsiElement())) != null && PhpImportClassQuickFix.INSTANCE.getCandidates(project, phpReference).size() > 0) {
            PhpImportClassQuickFix.INSTANCE.applyFix(project, descriptor);
        }
    }

    public static boolean isClassReferenceToTrait(PhpReference classReference) {
        boolean isReferenceToTrait = PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF) != null;
        return isReferenceToTrait &= PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)PhpClass.INSTANCEOF) != null;
    }

    @Nullable
    private static PsiFile separateFile(@NotNull Project project, @NotNull PhpReference classReference, @Nullable PhpExpression expression, @NotNull ProblemDescriptor descriptor, @Nullable PhpNewClassDataProvider dialog) {
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(5);
        }
        if (classReference == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(7);
        }
        if (dialog != null) {
            Properties properties = PhpCreateClassQuickFix.getDefaultDialogProperties(project, dialog);
            String filePath = dialog.getFilePath();
            PsiDirectory baseDir = dialog.getBaseDirectory();
            PsiFile file = PhpCreateClassQuickFix.createClassInSeparateFileAndDoFix(project, properties, filePath, baseDir, PhpBundle.message("create.new.class.quickfix", new Object[0]), dialog.getTemplateName(), expression, descriptor);
            PhpClass clazz = (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)file, PhpClass.class);
            if (CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)classReference)) {
                PhpCreateClassQuickFix.importExpression((PhpExpression)classReference, clazz);
            }
            if (file instanceof PhpFile) {
                PhpPsrNamespaceRootDetector.detectNewRootDirectory(project, (PhpFile)file, properties.getProperty("NAMESPACE"));
            }
            return file;
        }
        return null;
    }

    protected static PhpNewClassDataProvider getDataProvider(@NotNull Project project, @NotNull PhpReference classReference, @NotNull PsiFile containingFile) {
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(8);
        }
        if (classReference == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(9);
        }
        if (containingFile == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(10);
        }
        String namespaceName = classReference.getNamespaceName();
        boolean isReferenceToInterface = PhpCreateClassQuickFix.isReferenceToInterface(classReference);
        boolean isReferenceToTrait = PhpCreateClassQuickFix.isClassReferenceToTrait(classReference);
        ClassCreationType kindOfTemplate = ClassCreationType.CLASS;
        if (isReferenceToInterface) {
            kindOfTemplate = ClassCreationType.INTERFACE;
        }
        if (isReferenceToTrait) {
            kindOfTemplate = ClassCreationType.TRAIT;
        }
        return PhpCreateClassQuickFix.getDataProvider(project, classReference, kindOfTemplate, containingFile, namespaceName);
    }

    private static void importExpression(@Nullable PhpExpression expression, @Nullable PhpClass clazz) {
        if (expression == null || clazz == null) {
            return;
        }
        Project project = expression.getProject();
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            PsiReference reference = expression.getReference();
            if (reference instanceof PhpReference && PhpImportClassQuickFix.INSTANCE.getCandidates(project, (PhpReference)reference).size() > 0) {
                PhpImportClassQuickFix.INSTANCE.applyFix(project, (PhpReference)expression, (PhpNamedElement)clazz);
            }
        }), PhpBundle.message("create.new.class.quickfix", new Object[0]), null);
    }

    @NotNull
    public static Properties getDefaultDialogProperties(@NotNull Project project, PhpNewClassDataProvider dialog) {
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(11);
        }
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project);
        Properties properties = templateManager.getDefaultProperties();
        String name = dialog.getClassName();
        properties.setProperty("NAME", name);
        String namespaceFieldText = dialog.getNamespaceName();
        if (!namespaceFieldText.isEmpty()) {
            properties.setProperty("NAMESPACE", namespaceFieldText);
        }
        Properties properties2 = properties;
        if (properties2 == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(12);
        }
        return properties2;
    }

    private static boolean isReferenceToInterface(@NotNull PhpReference classReference) {
        if (classReference == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(13);
        }
        boolean firstCase = PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)((Condition)element -> element instanceof PhpClass && ((PhpClass)element).isInterface())) != null;
        boolean secondCase = PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)((Condition)element -> element instanceof ImplementsList)) != null;
        return (firstCase &= PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)((Condition)element -> element instanceof ExtendsList)) != null) || secondCase;
    }

    @Nullable
    protected static PhpNewClassDataProvider getDataProvider(@NotNull Project project, @NotNull PhpReference classReference, @NotNull ClassCreationType kindOfTemplate, @NotNull PsiFile containingFile, @NotNull String namespaceName) {
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(14);
        }
        if (classReference == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(15);
        }
        if (kindOfTemplate == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(16);
        }
        if (containingFile == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(17);
        }
        if (namespaceName == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(18);
        }
        String namespacePrefill = PhpLangUtil.toName(namespaceName);
        String className = classReference.getName();
        PsiDirectory contextDir = containingFile.getParent();
        PhpDirectoryProvider provider = PhpDirectoryByPsrProvider.getDefaultProvider();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            PhpNewClassDialog dialog = PhpCreateClassQuickFix.getDialog(project, className, kindOfTemplate, className, contextDir, provider, namespacePrefill);
            if (dialog.showAndGet()) {
                return dialog;
            }
        } else if (contextDir != null) {
            return PhpNewClassMockDataProvider.getMockProvider(project, kindOfTemplate, namespacePrefill, className, className, contextDir, provider);
        }
        return null;
    }

    @Nullable
    public static PsiFile createClassInSeparateFile(@NotNull Project project, @NotNull Properties properties, @NotNull String filePath, @NotNull PsiDirectory baseDir, @NotNull @NlsContexts.Command String actionName, @NotNull String templateName) {
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(19);
        }
        if (properties == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(20);
        }
        if (filePath == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(21);
        }
        if (baseDir == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(22);
        }
        if (actionName == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(23);
        }
        if (templateName == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(24);
        }
        return PhpCreateClassQuickFix.createClassInSeparateFile(project, properties, filePath, baseDir, actionName, templateName, (Consumer<? super PsiFile>)EmptyConsumer.getInstance());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static PsiFile createClassInSeparateFile(@NotNull Project project, @NotNull Properties properties, @NotNull String filePath, @NotNull PsiDirectory baseDir, @NotNull @NlsContexts.Command String actionName, @NotNull String templateName, @NotNull Consumer<? super PsiFile> postActionsOnCreatedFileMaker) {
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(25);
        }
        if (properties == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(26);
        }
        if (filePath == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(27);
        }
        if (baseDir == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(28);
        }
        if (actionName == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(29);
        }
        if (templateName == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(30);
        }
        if (postActionsOnCreatedFileMaker == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(31);
        }
        Ref fileRef = new Ref(null);
        @NlsSafe Ref exceptionRef = new Ref(null);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            Runnable run = () -> {
                try {
                    PsiFile file = PhpCreateClassQuickFix.createClass(project, filePath, baseDir, templateName, null, properties);
                    if (file != null) {
                        fileRef.set((Object)file);
                        postActionsOnCreatedFileMaker.consume((Object)file);
                    }
                }
                catch (IncorrectOperationException | PhpInvalidTemplateException | IOException e) {
                    exceptionRef.set((Object)e.getMessage());
                }
            };
            ApplicationManager.getApplication().runWriteAction(run);
        }, actionName, null);
        if (!exceptionRef.isNull()) {
            Messages.showErrorDialog((String)((String)exceptionRef.get()), (String)actionName);
            return null;
        }
        return (PsiFile)fileRef.get();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static PsiFile createClassInSeparateFileAndDoFix(@NotNull Project project, Properties properties, String filePath, PsiDirectory baseDir, @NlsContexts.Command String actionName, String templateName, @Nullable PhpExpression expression, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(32);
        }
        if (descriptor == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(33);
        }
        Ref fileRef = new Ref(null);
        @NlsSafe Ref exceptionRef = new Ref(null);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            Runnable run = () -> {
                try {
                    PsiFile file = PhpCreateClassQuickFix.createClass(project, filePath, baseDir, templateName, expression, properties);
                    if (file != null) {
                        fileRef.set((Object)file);
                        PhpCodeUtil.openRelatedFile(project, (PsiElement)file);
                    }
                }
                catch (IncorrectOperationException | PhpInvalidTemplateException | IOException e) {
                    exceptionRef.set((Object)e.getMessage());
                }
            };
            ApplicationManager.getApplication().runWriteAction(run);
        }, actionName, null);
        if (!exceptionRef.isNull()) {
            Messages.showErrorDialog((String)((String)exceptionRef.get()), (String)actionName);
            return null;
        }
        return (PsiFile)fileRef.get();
    }

    @Nullable
    private static PsiFile createClass(@NotNull Project project, @NotNull String filePath, @NotNull PsiDirectory baseDir, @NotNull String templateName, @Nullable PhpExpression expression, @NotNull Properties properties) throws IOException, PhpInvalidTemplateException, IncorrectOperationException {
        PsiDirectory parentDirectory;
        PsiElement file;
        List path;
        String fileName;
        PsiFile fileTemplate;
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(34);
        }
        if (filePath == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(35);
        }
        if (baseDir == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(36);
        }
        if (templateName == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(37);
        }
        if (properties == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(38);
        }
        if ((fileTemplate = PhpFileTemplateUtil.createPhpFileFromInternalTemplate(project, baseDir, templateName, properties, fileName = (String)(path = StringUtil.split((String)filePath.replace(File.separator, SEPARATOR), (String)SEPARATOR)).get(path.size() - 1))) == null) {
            throw new IncorrectOperationException(PhpBundle.message("error.template.unable.create.from.internal.template", templateName));
        }
        PhpClass phpClass = (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)fileTemplate, PhpClass.class, (boolean)false);
        if (expression instanceof NewExpression) {
            if (phpClass != null && !phpClass.isInterface() && !phpClass.isTrait()) {
                Pair<PhpDocComment, Method> commentMethodPair = PhpCreateClassQuickFix.createConstructor(project, phpClass, (NewExpression)expression);
                PsiElement inserted = PhpCodeEditUtil.insertClassMemberWithPhpDoc(phpClass, (PsiElement)commentMethodPair.second, (PhpDocComment)commentMethodPair.first);
                CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)inserted);
            } else {
                throw new IncorrectOperationException(PhpBundle.message("quickfix.failed.to.create.class", properties.getProperty("NAME")));
            }
        }
        if ((file = (parentDirectory = PhpFileCreator.createDirectory(path, baseDir)).add((PsiElement)fileTemplate)) instanceof PsiFile) {
            return (PsiFile)file;
        }
        return null;
    }

    @NotNull
    private static PhpNewClassDialog getDialog(@NotNull Project project, final @Nullable String className, final @NotNull ClassCreationType kindOfTemplate, final @Nullable String fileName, @Nullable PsiDirectory contextDir, final @NotNull PhpDirectoryProvider provider, final String namespaceName) {
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(39);
        }
        if (kindOfTemplate == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(40);
        }
        if (provider == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(41);
        }
        return new PhpNewClassDialog(project, contextDir){

            @Override
            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return this.myFileNameTextField;
            }

            @Override
            protected void init() {
                super.init();
                this.myTemplateComboBox.setEnabled(false);
                this.myNameTextField.setEnabled(false);
                this.setData(className, kindOfTemplate, fileName, namespaceName);
                this.myNamespaceCombobox.setEnabled(true);
                this.myDirectoryCombobox.setDirectoryProvider(provider);
            }

            @Override
            public boolean canInheritSuperClasses() {
                return false;
            }
        };
    }

    private static Pair<PhpDocComment, Method> createConstructor(Project project, @NotNull PhpClass myClass, @NotNull NewExpression newExpression) throws PhpInvalidTemplateException {
        if (myClass == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(42);
        }
        if (newExpression == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(43);
        }
        String constructorTemplate = PhpCodeUtil.getCodeTemplate("PHP Constructor", PhpCreateClassQuickFix.getConstructorAttributes(newExpression, myClass.getName()), project);
        constructorTemplate = constructorTemplate.replaceAll("(\\s*\\n)+", "\n");
        return PhpConstructorGenerator.createConstructorFromTemplate(project, myClass.isInterface(), constructorTemplate);
    }

    private static Properties getConstructorAttributes(@NotNull NewExpression newExpression, String name) {
        if (newExpression == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(44);
        }
        Properties properties = new Properties();
        properties.setProperty("CLASS_NAME", name);
        Collection<PhpParameterInfo> infos = PhpAddMethodDeclarationQuickFix.getParametersInfos((PhpExpression)newExpression);
        String makeParameterList = PhpAddMethodDeclarationQuickFix.makeParameterList(newExpression.getProject(), infos, null, false, false);
        String paramsDoc = PhpAddMethodDeclarationQuickFix.getParameterDoc((PhpExpression)newExpression);
        properties.setProperty("PARAM_LIST", makeParameterList.substring(1, makeParameterList.length() - 1));
        properties.setProperty("BODY", "");
        properties.setProperty("PARAM_DOC", paramsDoc);
        properties.setProperty("THROWS_DOC", "");
        return properties;
    }

    @IntentionFamilyName
    public static String getNameText() {
        return PhpBundle.message("quickfix.create.class", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/createClass/PhpCreateClassQuickFix";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 19: 
            case 25: 
            case 32: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 16: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kindOfTemplate";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 20: 
            case 26: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 21: 
            case 27: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 22: 
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 24: 
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postActionsOnCreatedFileMaker";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myClass";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/createClass/PhpCreateClassQuickFix";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDialogProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveImports";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "separateFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDataProvider";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDialogProperties";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToInterface";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createClassInSeparateFile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createClassInSeparateFileAndDoFix";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createClass";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDialog";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createConstructor";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpCreateClassLowPriority
    extends PhpCreateClassQuickFix
    implements LowPriorityAction {
        private PhpCreateClassLowPriority() {
        }
    }
}

