/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.assignment;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceAssignmentWithOperatorAssignmentQuickFix
implements LocalQuickFix {
    @Nls
    private final String myName;

    public ReplaceAssignmentWithOperatorAssignmentQuickFix(@Nls String name) {
        this.myName = name;
    }

    @NotNull
    public String getReplacementExpressionString(@NotNull AssignmentExpression assignment) {
        if (assignment == null) {
            ReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(0);
        }
        StringBuilder newExpression = new StringBuilder();
        PhpPsiElement variable = assignment.getVariable();
        assert (variable != null);
        newExpression.append(variable.getText());
        BinaryExpression expression = (BinaryExpression)assignment.getValue();
        assert (expression != null);
        newExpression.append(" ").append(ReplaceAssignmentWithOperatorAssignmentQuickFix.getOperatorText(expression)).append("= ");
        PsiElement leftOperand = expression.getLeftOperand();
        PsiElement rightOperand = expression.getRightOperand();
        assert (leftOperand != null && rightOperand != null);
        PsiElement operand = PsiEquivalenceUtil.areElementsEquivalent((PsiElement)variable, (PsiElement)leftOperand) ? rightOperand : leftOperand;
        newExpression.append(operand.getText());
        String string = newExpression.toString();
        if (string == null) {
            ReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String getOperatorText(@NotNull BinaryExpression expression) {
        if (expression == null) {
            ReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(2);
        }
        PsiElement operation = expression.getOperation();
        assert (operation != null);
        return operation.getText();
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = ReplaceAssignmentWithOperatorAssignmentQuickFix.getFamilyNameText();
        if (string == null) {
            ReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            ReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            ReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(6);
        }
        AssignmentExpression assignment = (AssignmentExpression)descriptor.getPsiElement();
        String replacementExpression = this.getReplacementExpressionString(assignment);
        SelfAssignmentExpression newExpressionElement = PhpPsiElementFactory.createFromText(project, SelfAssignmentExpression.class, replacementExpression);
        assert (newExpressionElement != null);
        assignment.replace((PsiElement)newExpressionElement);
    }

    @Nls
    private static String getFamilyNameText() {
        return PhpBundle.message("quickfix.replace.assignment.with.operator.assignment.family.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/assignment/ReplaceAssignmentWithOperatorAssignmentQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/assignment/ReplaceAssignmentWithOperatorAssignmentQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementExpressionString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementExpressionString";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOperatorText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

