/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.inspections.PhpUnitMissingTargetForTestInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpUnitCreateTargetClassQuickFix;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitCreateTargetMethodQuickFix
extends PhpUnitCreateTargetClassQuickFix {
    public static final PhpUnitCreateTargetMethodQuickFix ON_THE_FLY = new PhpUnitCreateTargetMethodQuickFix(true);
    public static final PhpUnitCreateTargetMethodQuickFix BATCH_MODE = new PhpUnitCreateTargetMethodQuickFix(false);

    protected PhpUnitCreateTargetMethodQuickFix(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.unit.create.target.method.quick.fix.family.name", new Object[0]);
        if (string == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Method testMethod;
        if (project == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(2);
        }
        if ((testMethod = (Method)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), Method.class, (boolean)false)) == null) {
            return;
        }
        PhpClass testClass = testMethod.getContainingClass();
        if (testClass == null) {
            return;
        }
        String targetMethodName = PhpUnitMissingTargetForTestInspection.getTargetMethodName(testMethod);
        PhpClass targetClass = this.getOrCreateTargetClass(project, descriptor, testClass, targetMethodName);
        if (targetClass == null || targetClass.findOwnMethodByName((CharSequence)targetMethodName) != null) {
            return;
        }
        PsiElement createdMethod = PhpCodeEditUtil.insertClassMember(targetClass, (PsiElement)PhpPsiElementFactory.createMethod(project, "public function " + targetMethodName + "(){}"));
        if (this.myOnTheFly && createdMethod != null) {
            PhpCodeUtil.openRelatedFile(project, createdMethod);
        }
    }

    @Nullable
    private PhpClass getOrCreateTargetClass(@NotNull Project project, @NotNull ProblemDescriptor descriptor, @NotNull PhpClass testClass, @NotNull String targetMethodName) {
        if (project == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(4);
        }
        if (testClass == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(5);
        }
        if (targetMethodName == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(6);
        }
        return PhpUnitMissingTargetForTestInspection.findTargetClasses(testClass).stream().filter(clazz -> clazz.findOwnMethodByName((CharSequence)targetMethodName) == null).findAny().orElseGet(() -> (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)this.createTargetClassFile(project, testClass, descriptor), PhpClass.class, (boolean)false));
    }

    @Override
    @NotNull
    @Nls
    protected String getActionName() {
        String string = PhpBundle.message("create.missing.target.method.fix", new Object[0]);
        if (string == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpUnitCreateTargetMethodQuickFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpUnitCreateTargetMethodQuickFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateTargetClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

