/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.actions.newClassDataProvider.ClassCreationType;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.inspections.quickfix.createClass.PhpCreateClassQuickFix;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpUnitTestDescriptor;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.validation.PhpFilePathValidationException;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import com.jetbrains.php.roots.PhpDirectoryProvider;
import java.util.List;
import java.util.Properties;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitCreateTargetClassQuickFix
extends PhpQuickFixBase {
    public static final PhpUnitCreateTargetClassQuickFix ON_THE_FLY = new PhpUnitCreateTargetClassQuickFix(true);
    public static final PhpUnitCreateTargetClassQuickFix BATCH_MODE = new PhpUnitCreateTargetClassQuickFix(false);
    protected boolean myOnTheFly;

    protected PhpUnitCreateTargetClassQuickFix(boolean onTheFly) {
        this.myOnTheFly = onTheFly;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.unit.create.target.class.quick.fix.family.name", new Object[0]);
        if (string == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @Nls
    protected String getActionName() {
        String string = PhpBundle.message("create.target.class.quick.fix", new Object[0]);
        if (string == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PhpClass testClass;
        PsiFile createdFile;
        if (project == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(3);
        }
        if ((createdFile = this.createTargetClassFile(project, testClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PhpClass.class, (boolean)false), descriptor)) != null && this.myOnTheFly) {
            PhpCodeUtil.openRelatedFile(project, (PsiElement)createdFile);
        }
    }

    @Nullable
    protected PsiFile createTargetClassFile(@NotNull Project project, @Nullable PhpClass testClass, @NotNull ProblemDescriptor descriptor) {
        String targetClassName;
        if (project == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(5);
        }
        if ((targetClassName = PhpUnitTestDescriptor.getTargetClassName(testClass)) == null) {
            return null;
        }
        String targetClassFileName = targetClassName + "." + PhpFileType.INSTANCE.getDefaultExtension();
        PhpFileCreationInfo info = PhpUnitCreateTargetClassQuickFix.createFileCreationInfo(project, testClass, targetClassFileName);
        if (info == null) {
            return null;
        }
        if (info.getBaseDirectory().findFile(targetClassFileName) != null) {
            if (this.myOnTheFly) {
                PhpUnitCreateTargetClassQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.phpunit.create.target.class.error.filename.exists", targetClassFileName), descriptor.getStartElement());
            }
            return null;
        }
        return PhpCreateClassQuickFix.createClassInSeparateFile(project, PhpUnitCreateTargetClassQuickFix.getProperties(project, targetClassName, PhpLangUtil.toName(testClass.getNamespaceName())), info.getRelativePath(), info.getBaseDirectory(), this.getActionName(), ClassCreationType.CLASS.getTemplateName());
    }

    @Nullable
    private static PhpFileCreationInfo createFileCreationInfo(@NotNull Project project, @NotNull PhpClass testClass, @NotNull String targetClassFileName) {
        if (project == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(6);
        }
        if (testClass == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(7);
        }
        if (targetClassFileName == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(8);
        }
        String testClassDirectoryPath = testClass.getContainingFile().getContainingDirectory().getVirtualFile().getPath();
        PhpFileCreationInfo defaultCreateInfo = PhpUnitCreateTargetClassQuickFix.createFileCreationInfo(project, testClassDirectoryPath, targetClassFileName);
        if (!ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(testClass.getContainingFile().getVirtualFile())) {
            return defaultCreateInfo;
        }
        return StreamEx.of(PhpUnitCreateTargetClassQuickFix.getSuggestedPaths(project, testClass.getNamespaceName())).map(path -> PhpUnitCreateTargetClassQuickFix.createFileCreationInfo(project, path, targetClassFileName)).nonNull().findAny().orElse(defaultCreateInfo);
    }

    @Nullable
    private static PhpFileCreationInfo createFileCreationInfo(@NotNull Project project, @NotNull String path, @NotNull String targetClassFileName) {
        if (project == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(9);
        }
        if (path == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(10);
        }
        if (targetClassFileName == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(11);
        }
        try {
            return PhpFileCreationInfo.generateConfiguration(project, path, targetClassFileName);
        }
        catch (PhpFilePathValidationException e) {
            return null;
        }
    }

    @NotNull
    private static List<String> getSuggestedPaths(@NotNull Project project, @NotNull String namespaceName) {
        if (project == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(12);
        }
        if (namespaceName == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(13);
        }
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
        ProjectFileIndex index = rootManager.getFileIndex();
        PhpDirectoryProvider provider = PhpDirectoryByPsrProvider.getSourceRootProvide();
        List list = ((StreamEx)StreamEx.of((Object[])rootManager.getContentSourceRoots()).filter(root -> !index.isInTestSourceContent(root))).flatMap(root -> provider.suggestDirectories(project, (VirtualFile)root, namespaceName).stream()).map(path -> FileUtil.toCanonicalPath((String)path)).toList();
        if (list == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private static Properties getProperties(@NotNull Project project, @NotNull String className, @NotNull String namespaceName) {
        if (project == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(15);
        }
        if (className == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(16);
        }
        if (namespaceName == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(17);
        }
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project);
        Properties properties = templateManager.getDefaultProperties();
        properties.setProperty("NAME", className);
        if (!StringUtil.isEmpty((String)namespaceName)) {
            properties.setProperty("NAMESPACE", namespaceName);
        }
        Properties properties2 = properties;
        if (properties2 == null) {
            PhpUnitCreateTargetClassQuickFix.$$$reportNull$$$0(18);
        }
        return properties2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpUnitCreateTargetClassQuickFix";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassFileName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpUnitCreateTargetClassQuickFix";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedPaths";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTargetClassFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFileCreationInfo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedPaths";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

