/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.surroundWith.PhpTryCatchSurrounder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J3\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0096\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/php/lang/inspections/quickfix/PhpSurroundWithTryCatchQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "findStatement", "Lcom/jetbrains/php/lang/psi/elements/Statement;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "endElement", "intellij.php.impl"})
public final class PhpSurroundWithTryCatchQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    public String getText() {
        String string = PhpBundle.message("php.surround.with.try.catch.quick.fix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PhpBundle.message(\"php.s\u2026ith.try.catch.quick.fix\")");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement element, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Statement statement = this.findStatement(element);
        Editor editor2 = editor;
        Object caretModel = editor2 != null ? editor2.getCaretModel() : null;
        CaretModel caretModel2 = caretModel;
        int col = caretModel2 != null && (caretModel2 = caretModel2.getLogicalPosition()) != null ? caretModel2.column : 0;
        CaretModel caretModel3 = caretModel;
        int line = caretModel3 != null && (caretModel3 = caretModel3.getLogicalPosition()) != null ? caretModel3.line : 0;
        CaretModel caretModel4 = caretModel;
        if (caretModel4 != null) {
            caretModel4.moveToLogicalPosition(new LogicalPosition(0, 0));
        }
        TextRange textRange = new PhpTryCatchSurrounder().surroundElements(project, (PsiElement[])new Statement[]{statement});
        Intrinsics.checkNotNull((Object)textRange);
        TextRange range = textRange;
        if (caretModel != null) {
            caretModel.moveToLogicalPosition(new LogicalPosition(line, col));
            caretModel.moveToOffset(range.getStartOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    private final Statement findStatement(PsiElement element) {
        Statement statement;
        Object t = PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        Intrinsics.checkNotNull(t);
        Intrinsics.checkNotNullExpressionValue(t, (String)"PhpPsiUtil.getParentByCo\u2026, Statement.INSTANCEOF)!!");
        Statement statement2 = (Statement)t;
        if (statement2 instanceof ElseIf || statement2 instanceof PhpCase) {
            PsiElement psiElement = statement2.getParent();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.Statement");
            }
            statement = (Statement)psiElement;
        } else {
            statement = statement2;
        }
        return statement;
    }

    public PhpSurroundWithTryCatchQuickFix(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
    }
}

