/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveAllStatementsQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PhpRemoveStatementQuickFix
extends PhpRemoveAllStatementsQuickFix {
    public static final PhpRemoveStatementQuickFix REMOVE_USE = new PhpRemoveStatementQuickFix("use statement", PhpUse.INSTANCEOF, PhpTokenTypes.opCOMMA){

        @Override
        @Nullable
        protected PsiElement getElementToRemove(@Nullable PsiElement element) {
            List nestedUses;
            Object useBrace;
            PsiElement elementToRemove = super.getElementToRemove(element);
            if (elementToRemove != null && (useBrace = PhpPsiUtil.getParentByCondition(element, false, PhpUseImpl.USE_BRACES_CONDITION)) != null && (nestedUses = PhpPsiUtil.getChildren(useBrace, (Condition<? super PsiElement>)PhpUse.INSTANCEOF)).size() == 1) {
                return useBrace;
            }
            return elementToRemove;
        }
    };
    protected final Condition<PsiElement> condition;

    public PhpRemoveStatementQuickFix(String name, Condition<PsiElement> condition, @Nullable IElementType delivery) {
        super(name, delivery);
        this.condition = condition;
    }

    public PhpRemoveStatementQuickFix(String name, Condition<PsiElement> condition) {
        this(name, condition, null);
    }

    @Nullable
    protected PsiElement getElementToRemove(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        return PhpPsiUtil.getParentByCondition(element, false, this.condition);
    }

    @Override
    @Nullable
    protected List<PsiElement> getElementsToRemove(@Nullable PsiElement element) {
        PsiElement conditionElement = this.getElementToRemove(element);
        return conditionElement == null ? null : new SmartList((Object)conditionElement);
    }
}

