/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpRemoveAllStatementsQuickFix
implements LocalQuickFix {
    @IntentionFamilyName
    private final String name;
    private final IElementType delivery;

    public PhpRemoveAllStatementsQuickFix(@NotNull String name, @Nullable IElementType delivery) {
        if (name == null) {
            PhpRemoveAllStatementsQuickFix.$$$reportNull$$$0(0);
        }
        this.name = PhpBundle.message("intention.family.name.remove", name);
        this.delivery = delivery;
    }

    @NotNull
    public final String getFamilyName() {
        String string = this.name;
        if (string == null) {
            PhpRemoveAllStatementsQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpRemoveAllStatementsQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpRemoveAllStatementsQuickFix.$$$reportNull$$$0(3);
        }
        PsiElement element = descriptor.getPsiElement();
        this.remove(element);
    }

    public void remove(@Nullable PsiElement element) {
        List<PsiElement> conditionElements = this.getElementsToRemove(element);
        if (conditionElements != null) {
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(conditionElements)) {
                return;
            }
            for (PsiElement psiElement : conditionElements) {
                PhpDocComment comment = psiElement instanceof PhpNamedElement ? ((PhpNamedElement)psiElement).getDocComment() : null;
                PhpCodeEditUtil.removeStatementWithDelivery(psiElement, this.delivery);
                if (comment == null) continue;
                this.updatePhpDoc(comment);
            }
        }
    }

    protected void updatePhpDoc(@NotNull PhpDocComment comment) {
        if (comment == null) {
            PhpRemoveAllStatementsQuickFix.$$$reportNull$$$0(4);
        }
        comment.delete();
    }

    @Nullable
    protected abstract List<PsiElement> getElementsToRemove(@Nullable PsiElement var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpRemoveAllStatementsQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpRemoveAllStatementsQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updatePhpDoc";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

