/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.quickfix.PhpChangeMethodModifiersQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpMakeMethodNonAbstractQuickFix
implements LocalQuickFix {
    public static final LocalQuickFix INSTANCE = new PhpMakeMethodNonAbstractQuickFix();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.make.method.non.abstract.quick.fix.family.name", new Object[0]);
        if (string == null) {
            PhpMakeMethodNonAbstractQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Method method;
        if (project == null) {
            PhpMakeMethodNonAbstractQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpMakeMethodNonAbstractQuickFix.$$$reportNull$$$0(2);
        }
        if ((method = (Method)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)Method.INSTANCEOF)) == null) {
            return;
        }
        PhpChangeMethodModifiersQuickFix.changeMethodModifier(method, method.getModifier().copy(PhpModifier.Abstractness.IMPLEMENTED));
        this.addBody(method);
    }

    protected void addBody(Method method) {
        if (PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF) != null) {
            return;
        }
        Method dummyMethod = PhpPsiElementFactory.createMethod(method.getProject(), String.format("public function a() {\n        // TODO: Implement %s() method.\n    }", method.getName()));
        Object body = PhpPsiUtil.getChildByCondition((PsiElement)dummyMethod, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (body == null) {
            return;
        }
        PsiElement child = method.getLastChild();
        child.replace(body);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpMakeMethodNonAbstractQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpMakeMethodNonAbstractQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

