/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.google.common.collect.Iterables;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.refactoring.PhpNameUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PhpIntroduceCatchVariableQuickFix
implements LocalQuickFix {
    public static final LocalQuickFix INSTANCE = new PhpIntroduceCatchVariableQuickFix();

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("introduce.variable.fix", new Object[0]);
        if (string == null) {
            PhpIntroduceCatchVariableQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Catch element;
        if (project == null) {
            PhpIntroduceCatchVariableQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpIntroduceCatchVariableQuickFix.$$$reportNull$$$0(2);
        }
        if ((element = (Catch)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), Catch.class)) == null) {
            return;
        }
        ClassReference lastType = (ClassReference)Iterables.getLast((Iterable)element.getExceptionTypes());
        PsiElement newVar = PhpIntroduceCatchVariableQuickFix.createUniqVariable(element, lastType);
        if (newVar.getPrevSibling() instanceof PsiWhiteSpace) {
            return;
        }
        element.addBefore((PsiElement)PhpPsiElementFactory.createWhiteSpace(project), newVar);
    }

    private static PsiElement createUniqVariable(Catch element, ClassReference lastType) {
        Set<String> occupiedNames = VariableImpl.collectDeclarations((PsiElement)element, true, null).stream().map(it -> it.getName()).collect(Collectors.toSet());
        ArrayList<String> names = new ArrayList<String>(List.of("ex"));
        PhpNameUtil.unique(names, occupiedNames);
        return element.addAfter((PsiElement)PhpPsiElementFactory.createVariable(element.getProject(), (String)names.get(0), true), (PsiElement)lastType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpIntroduceCatchVariableQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpIntroduceCatchVariableQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

