/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseImportQuickFix;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpAttributesFQNsIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpImportClassQuickFix
extends PhpBaseImportQuickFix<PhpClass> {
    public static final PhpImportClassQuickFix INSTANCE = new PhpImportClassQuickFix();
    public static final String[] IGNORABLE_NAMESPACES = new String[]{"\\___PHPSTORM_HELPERS\\"};

    @NotNull
    public String getFamilyName() {
        String string = PhpImportClassQuickFix.getNameText();
        if (string == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    @NlsContexts.Command
    protected String getCommandName() {
        String string = PhpImportClassQuickFix.getNameText();
        if (string == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getImportPopupTitle() {
        String string = PhpBundle.message("quickfix.import.class.popup.title", new Object[0]);
        if (string == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getImportKeyword() {
        return null;
    }

    @Override
    protected void replaceReference(@NotNull Project project, @NotNull PhpReference reference, @NotNull String fqn) {
        if (project == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(3);
        }
        if (reference == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(4);
        }
        if (fqn == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(5);
        }
        ClassReference qualifiedClassReference = PhpPsiElementFactory.createClassReference(project, PhpLangUtil.toPresentableFQN(fqn));
        reference.replace((PsiElement)qualifiedClassReference);
    }

    @Override
    @NotNull
    public Collection<PhpClass> getCandidates(@NotNull Project project, @NotNull PhpReference reference) {
        if (project == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(6);
        }
        if (reference == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(7);
        }
        String name = PhpType.isPluralType((String)reference.getText()) ? StringUtil.trimEnd((String)reference.getText(), (String)"[]") : reference.getText();
        LinkedHashMap<String, PhpClass> candidates = new LinkedHashMap<String, PhpClass>();
        PhpImportClassQuickFix.addFilteredClasses(candidates, PhpImportClassQuickFix.getImportOptions(reference).getClasses(project, name));
        Collection<PhpClass> collection = candidates.values();
        if (collection == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(8);
        }
        return collection;
    }

    private static void addFilteredClasses(@NotNull Map<String, PhpClass> targetList, @NotNull Collection<PhpClass> sourceClasses) {
        if (targetList == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(9);
        }
        if (sourceClasses == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(10);
        }
        for (PhpClass phpClass : sourceClasses) {
            String namespace = phpClass.getNamespaceName();
            boolean ignore = false;
            for (String ignorableNamepsace : IGNORABLE_NAMESPACES) {
                if (!ignorableNamepsace.equals(namespace)) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            targetList.put(phpClass.getFQN(), phpClass);
        }
    }

    @NotNull
    public static Options getImportOptions(@NotNull PhpReference classReference) {
        PsiElement target;
        IElementType targetType;
        if (classReference == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(11);
        }
        if ((targetType = PsiUtilCore.getElementType((PsiElement)(target = classReference.getParent()))) == PhpStubElementTypes.ATTRIBUTE) {
            Options options = Options.IMPORT_ATTRIBUTES;
            if (options == null) {
                PhpImportClassQuickFix.$$$reportNull$$$0(12);
            }
            return options;
        }
        if (targetType == PhpElementTypes.USE && PhpPsiUtil.getParentByCondition(target, (Condition<? super PsiElement>)PhpClass.INSTANCEOF) != null) {
            Options options = Options.IMPORT_TRAITS;
            if (options == null) {
                PhpImportClassQuickFix.$$$reportNull$$$0(13);
            }
            return options;
        }
        if (targetType == PhpElementTypes.IMPLEMENTS_LIST) {
            Options options = Options.IMPORT_INTERFACES;
            if (options == null) {
                PhpImportClassQuickFix.$$$reportNull$$$0(14);
            }
            return options;
        }
        if (targetType == PhpElementTypes.EXTENDS_LIST || targetType == PhpElementTypes.NEW_EXPRESSION) {
            Options options = Options.IMPORT_CLASSES;
            if (options == null) {
                PhpImportClassQuickFix.$$$reportNull$$$0(15);
            }
            return options;
        }
        Options options = Options.IMPORT_ALL;
        if (options == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(16);
        }
        return options;
    }

    @IntentionFamilyName
    public static String getNameText() {
        return PhpBundle.message("quickfix.import.class.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpImportClassQuickFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetList";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClasses";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPopupTitle";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpImportClassQuickFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCandidates";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFilteredClasses";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getImportOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Options {
        IMPORT_INTERFACES{

            @Override
            public Collection<PhpClass> getClasses(Project project, String name) {
                return PhpIndex.getInstance((Project)project).getInterfacesByName(name);
            }
        }
        ,
        IMPORT_CLASSES{

            @Override
            public Collection<PhpClass> getClasses(Project project, String name) {
                return PhpIndex.getInstance((Project)project).getClassesByName(name);
            }
        }
        ,
        IMPORT_TRAITS{

            @Override
            public Collection<PhpClass> getClasses(Project project, String name) {
                return PhpIndex.getInstance((Project)project).getTraitsByName(name);
            }
        }
        ,
        IMPORT_ALL{

            @Override
            public Collection<PhpClass> getClasses(Project project, String name) {
                ArrayList<PhpClass> res = new ArrayList<PhpClass>();
                res.addAll(IMPORT_CLASSES.getClasses(project, name));
                res.addAll(IMPORT_INTERFACES.getClasses(project, name));
                res.addAll(IMPORT_TRAITS.getClasses(project, name));
                return res;
            }
        }
        ,
        IMPORT_ATTRIBUTES{

            @Override
            public Collection<PhpClass> getClasses(Project project, String name) {
                return ContainerUtil.filter(IMPORT_ALL.getClasses(project, name), PhpAttributesFQNsIndex::hasRootAttribute);
            }
        };


        public abstract Collection<PhpClass> getClasses(Project var1, String var2);
    }
}

