/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExchangeExtendsImplementsQuickFix
implements IntentionAction {
    @IntentionName
    private final String myName;
    private final boolean toExtends;
    private final ClassReference myClassReference;
    private final PhpClass myClass;

    public PhpExchangeExtendsImplementsQuickFix(PhpClass aClass, @NotNull ClassReference myClassToExtendFromRef) {
        if (myClassToExtendFromRef == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(0);
        }
        PhpClass myClassToExtendFrom = (PhpClass)myClassToExtendFromRef.resolve();
        this.myClass = aClass;
        this.myClassReference = myClassToExtendFromRef;
        assert (myClassToExtendFrom != null);
        this.toExtends = aClass.isInterface() == myClassToExtendFrom.isInterface();
        this.myName = PhpBundle.message("php.annotator.exchange.extends.implements.keyword", this.toExtends ? "implements" : "extends", this.toExtends ? "extends" : "implements", myClassToExtendFrom.getName());
    }

    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("replace.extends.implements", new Object[0]);
        if (string == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(3);
        }
        return this.myClass.isValid() && this.myClass.getManager().isInProject((PsiElement)file) && (!this.toExtends || this.myClass.getExtendsList().getReferenceElements().size() <= 0);
    }

    @Nullable
    private static PsiWhiteSpace getNextWhiteSpace(PhpPsiElement element) {
        PsiElement sibling = element.getNextSibling();
        return sibling instanceof PsiWhiteSpace && sibling.textContains('\n') ? (PsiWhiteSpace)sibling : null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PhpClass declaration;
        if (project == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(4);
        }
        if ((declaration = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)this.myClassReference, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null) {
            ExtendsList extendsList = declaration.getExtendsList();
            ImplementsList implementsList = declaration.getImplementsList();
            if (!this.toExtends) {
                ExtendsList emptyExtendsList = PhpPsiElementFactory.createFromText(extendsList.getProject(), ExtendsList.class, "class A ");
                if (emptyExtendsList != null) {
                    extendsList.replace((PsiElement)emptyExtendsList);
                }
            } else {
                ImplementsList emptyImplementsList;
                List elements = implementsList.getReferenceElements();
                assert (elements.size() > 0);
                if (elements.size() == 1 && (emptyImplementsList = PhpPsiElementFactory.createFromText(extendsList.getProject(), ImplementsList.class, "class A ")) != null) {
                    implementsList.replace((PsiElement)emptyImplementsList);
                }
            }
            this.updateList(extendsList, implementsList, this.myClassReference, this.toExtends);
            PsiWhiteSpace space = PhpExchangeExtendsImplementsQuickFix.getNextWhiteSpace((PhpPsiElement)this.myClass.getExtendsList());
            if (space != null) {
                space.replace((PsiElement)PhpPsiElementFactory.createWhiteSpace(project));
            }
        }
    }

    public void updateList(@NotNull ExtendsList extendsList, @NotNull ImplementsList implementsList, @NotNull ClassReference classReference, boolean toExtends) {
        if (extendsList == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(5);
        }
        if (implementsList == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(6);
        }
        if (classReference == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(7);
        }
        if (toExtends) {
            List referenceElements = extendsList.getReferenceElements();
            if (referenceElements.isEmpty()) {
                ExtendsList newExtendsList = PhpPsiElementFactory.createFromText(extendsList.getProject(), ExtendsList.class, "class A extends " + classReference.getText());
                if (newExtendsList != null) {
                    extendsList.replace((PsiElement)newExtendsList);
                }
            } else {
                this.addClassReferenceToExtendsList(extendsList, classReference);
            }
        } else {
            List referenceElements = implementsList.getReferenceElements();
            if (referenceElements.isEmpty()) {
                ImplementsList newImplementsList = PhpPsiElementFactory.createFromText(extendsList.getProject(), ImplementsList.class, "class A implements " + classReference.getText());
                if (newImplementsList != null) {
                    implementsList.replace((PsiElement)newImplementsList);
                }
            } else {
                this.addClassReferenceToImplementsList(implementsList, classReference);
            }
        }
    }

    public void addClassReferenceToImplementsList(@NotNull ImplementsList implementsList, @NotNull ClassReference classReference) {
        if (implementsList == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(8);
        }
        if (classReference == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(9);
        }
        Object text = implementsList.getText();
        text = (String)text + "," + classReference.getText();
        ImplementsList newImplementsList = PhpPsiElementFactory.createFromText(classReference.getProject(), ImplementsList.class, "class A " + (String)text);
        if (newImplementsList != null) {
            implementsList.replace((PsiElement)newImplementsList);
        }
    }

    public void addClassReferenceToExtendsList(@NotNull ExtendsList extendsList, @NotNull ClassReference classReference) {
        if (extendsList == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(10);
        }
        if (classReference == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(11);
        }
        Object text = extendsList.getText();
        text = (String)text + "," + classReference.getText();
        ExtendsList newExtendsList = PhpPsiElementFactory.createFromText(classReference.getProject(), ExtendsList.class, "class A " + (String)text);
        if (newExtendsList != null) {
            extendsList.replace((PsiElement)newExtendsList);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myClassToExtendFromRef";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpExchangeExtendsImplementsQuickFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendsList";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementsList";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpExchangeExtendsImplementsQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateList";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addClassReferenceToImplementsList";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addClassReferenceToExtendsList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

