/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.quickfix.PhpDeleteExceptionQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Try;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/php/lang/inspections/quickfix/PhpDeleteExceptionQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "clauseToDelete", "", "exceptionToDelete", "(II)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "intellij.php.impl"})
public final class PhpDeleteExceptionQuickFix
implements LocalQuickFix {
    private final int clauseToDelete;
    private final int exceptionToDelete;

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.delete.exception.quick.fix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PhpBundle.message(\"php.d\u2026ete.exception.quick.fix\")");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        List list;
        Catch catch_;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Try try_ = (Try)PhpPsiUtil.getParentByCondition(descriptor.getPsiElement(), (Condition<? super PsiElement>)((Condition)applyFix.tryStatement.1.INSTANCE));
        if (try_ == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)try_, (String)"PhpPsiUtil.getParentByCo\u2026 { it is Try }) ?: return");
        Try tryStatement2 = try_;
        Catch[] catches = tryStatement2.getCatchClauses();
        if (this.clauseToDelete >= catches.length) {
            return;
        }
        Catch catch_2 = catch_ = catches[this.clauseToDelete];
        Intrinsics.checkNotNullExpressionValue((Object)catch_2, (String)"catch");
        Collection collection = catch_2.getExceptionTypes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"catch.exceptionTypes");
        Collection caughtExceptions = collection;
        if (this.exceptionToDelete >= caughtExceptions.size()) {
            return;
        }
        Collection collection2 = caughtExceptions;
        if (!(collection2 instanceof List)) {
            collection2 = null;
        }
        if ((list = (List)collection2) == null) {
            list = CollectionsKt.toList((Iterable)caughtExceptions);
        }
        Object e = list.get(this.exceptionToDelete);
        if (e == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.ClassReference");
        }
        ClassReference caughtException = (ClassReference)e;
        PsiElement pipe = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)caughtException, true);
        if (PhpPsiUtil.isOfType(pipe, PhpTokenTypes.opBIT_OR)) {
            PsiElement psiElement = pipe;
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement last = PhpPsiUtil.isOfType(psiElement.getNextSibling(), TokenType.WHITE_SPACE) ? pipe.getNextSibling() : pipe;
            catch_.deleteChildRange((PsiElement)caughtException, last);
        } else {
            pipe = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)caughtException, true);
            if (PhpPsiUtil.isOfType(pipe, PhpTokenTypes.opBIT_OR)) {
                PsiElement psiElement = pipe;
                Intrinsics.checkNotNull((Object)psiElement);
                PsiElement first = PhpPsiUtil.isOfType(psiElement.getPrevSibling(), TokenType.WHITE_SPACE) ? pipe.getPrevSibling() : pipe;
                catch_.deleteChildRange(first, (PsiElement)caughtException);
            }
        }
    }

    public PhpDeleteExceptionQuickFix(int clauseToDelete, int exceptionToDelete) {
        this.clauseToDelete = clauseToDelete;
        this.exceptionToDelete = exceptionToDelete;
    }
}

