/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayMapInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpConvertLoopToArrayMapQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConvertLoopToArrayFilterQuickFix
extends PhpQuickFixBase {
    public static final PhpConvertLoopToArrayFilterQuickFix INSTANCE = new PhpConvertLoopToArrayFilterQuickFix();

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpConvertLoopToArrayFilterQuickFix.getNameText();
        if (string == null) {
            PhpConvertLoopToArrayFilterQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        String resultArrayName;
        ForeachStatement foreach;
        if (project == null) {
            PhpConvertLoopToArrayFilterQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpConvertLoopToArrayFilterQuickFix.$$$reportNull$$$0(2);
        }
        if ((foreach = (ForeachStatement)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)ForeachStatement.INSTANCEOF)) == null) {
            return;
        }
        Statement prevStatement = (Statement)PhpPsiUtil.getPrevSiblingByCondition((PsiElement)foreach, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        AssignmentExpression emptyArrayDeclaration = PhpLoopCanBeConvertedToArrayMapInspection.getEmptyArrayDeclaration(prevStatement);
        PhpPsiElement resultArray = emptyArrayDeclaration != null ? emptyArrayDeclaration.getVariable() : null;
        String string = resultArrayName = resultArray != null ? resultArray.getName() : null;
        if (resultArrayName == null) {
            return;
        }
        Statement arrayFilterStatement = PhpConvertLoopToArrayFilterQuickFix.createArrayFilterStatement(project, foreach, resultArrayName);
        if (arrayFilterStatement != null) {
            PhpLangUtil.addCopiedCommentsBeforeElement((PsiElement)foreach);
            foreach.replace((PsiElement)arrayFilterStatement);
            prevStatement.delete();
        }
    }

    @Nullable
    private static Statement createArrayFilterStatement(@NotNull Project project, @NotNull ForeachStatement foreach, @NotNull String resultArrayName) {
        String valueName;
        PhpPsiElement condition;
        PsiElement array;
        if (project == null) {
            PhpConvertLoopToArrayFilterQuickFix.$$$reportNull$$$0(3);
        }
        if (foreach == null) {
            PhpConvertLoopToArrayFilterQuickFix.$$$reportNull$$$0(4);
        }
        if (resultArrayName == null) {
            PhpConvertLoopToArrayFilterQuickFix.$$$reportNull$$$0(5);
        }
        if ((array = foreach.getArray()) == null) {
            return null;
        }
        If anIf = (If)ObjectUtils.tryCast((Object)PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(foreach.getStatement()), If.class);
        PhpPsiElement phpPsiElement = condition = anIf != null ? anIf.getCondition() : null;
        if (condition == null) {
            return null;
        }
        Set<String> variableNames = PhpLoopCanBeConvertedToArrayMapInspection.collectUsedVariables((PsiElement)condition, Collections.emptySet());
        Variable key = foreach.getKey();
        String keyName = key != null ? key.getName() : null;
        Variable value = foreach.getValue();
        String string = valueName = value != null ? value.getName() : null;
        if (valueName == null || keyName == null) {
            return null;
        }
        boolean keyUsed = variableNames.remove(keyName);
        boolean valueUsed = variableNames.remove(valueName);
        String arrayFilterText = PhpConvertLoopToArrayFilterQuickFix.createArrayFilterText(array.getText(), valueName, keyName, PhpConvertLoopToArrayMapQuickFix.createUseListStatement(variableNames), condition.getText(), keyUsed, valueUsed);
        return PhpPsiElementFactory.createStatement(project, String.format("$%s = %s;", resultArrayName, arrayFilterText));
    }

    @NotNull
    private static String createArrayFilterText(@NotNull String arrayName, @NotNull String valueName, @NotNull String keyName, @NotNull String useList, @NotNull String conditionValue, boolean keyUsed, boolean valueUsed) {
        String closureParameters;
        if (arrayName == null) {
            PhpConvertLoopToArrayFilterQuickFix.$$$reportNull$$$0(6);
        }
        if (valueName == null) {
            PhpConvertLoopToArrayFilterQuickFix.$$$reportNull$$$0(7);
        }
        if (keyName == null) {
            PhpConvertLoopToArrayFilterQuickFix.$$$reportNull$$$0(8);
        }
        if (useList == null) {
            PhpConvertLoopToArrayFilterQuickFix.$$$reportNull$$$0(9);
        }
        if (conditionValue == null) {
            PhpConvertLoopToArrayFilterQuickFix.$$$reportNull$$$0(10);
        }
        String string = keyUsed && valueUsed ? "$" + valueName + ", $" + keyName : (closureParameters = keyUsed ? "$" + keyName : "$" + valueName);
        String flagArgument = keyUsed && valueUsed ? ", ARRAY_FILTER_USE_BOTH" : (keyUsed ? ", ARRAY_FILTER_USE_KEY" : "");
        String string2 = String.format("array_filter(%s, function(%s) %s {return %s;} %s)", arrayName, closureParameters, useList, conditionValue, flagArgument);
        if (string2 == null) {
            PhpConvertLoopToArrayFilterQuickFix.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Nls
    public static String getNameText() {
        return PhpBundle.message("quickfix.convert.loop.to.arrayfilter", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpConvertLoopToArrayFilterQuickFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreach";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultArrayName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useList";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpConvertLoopToArrayFilterQuickFix";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayFilterText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createArrayFilterStatement";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createArrayFilterText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

