/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.codeStyle.PhpArrayFilterCanBeConvertedToLoopInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpConvertArrayFilterToLoopQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpConvertLoopToArrayMapQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConvertArrayMapToLoopQuickFix
extends PhpQuickFixBase {
    @Nls
    @NotNull
    public String getName() {
        String string = PhpConvertArrayMapToLoopQuickFix.getNameText();
        if (string == null) {
            PhpConvertArrayMapToLoopQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpConvertArrayMapToLoopQuickFix.getNameText();
        if (string == null) {
            PhpConvertArrayMapToLoopQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        FunctionReference arrayMapCall;
        if (project == null) {
            PhpConvertArrayMapToLoopQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpConvertArrayMapToLoopQuickFix.$$$reportNull$$$0(3);
        }
        if ((arrayMapCall = (FunctionReference)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF)) == null) {
            return;
        }
        String resultArrayName = PhpConvertArrayFilterToLoopQuickFix.getResultArrayName(arrayMapCall);
        PhpConvertArrayFilterToLoopQuickFix.replaceCallWithStatement(project, arrayMapCall, resultArrayName, (PsiElement)PhpConvertArrayMapToLoopQuickFix.createForeach(project, arrayMapCall, resultArrayName), new PsiElement[0]);
    }

    @Nullable
    private static ForeachStatement createForeach(@NotNull Project project, @NotNull FunctionReference arrayMapCall, @NotNull String declaredArrayName) {
        PsiElement[] arguments;
        if (project == null) {
            PhpConvertArrayMapToLoopQuickFix.$$$reportNull$$$0(4);
        }
        if (arrayMapCall == null) {
            PhpConvertArrayMapToLoopQuickFix.$$$reportNull$$$0(5);
        }
        if (declaredArrayName == null) {
            PhpConvertArrayMapToLoopQuickFix.$$$reportNull$$$0(6);
        }
        if ((arguments = arrayMapCall.getParameters()).length != 2) {
            return null;
        }
        Function closure = PhpConvertArrayMapToLoopQuickFix.resolveFunction(arguments[0]);
        Parameter parameter = closure != null ? closure.getParameter(0) : null;
        String valueText = parameter != null ? parameter.getText() : "$value";
        String iteratedArray = arguments[1].getText();
        String foreachBody = PhpConvertArrayMapToLoopQuickFix.getForeachBody(PhpConvertLoopToArrayMapQuickFix.unwrapGroupStatement((GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)closure, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF), 0), declaredArrayName, PhpArrayFilterCanBeConvertedToLoopInspection.canBeCalledAsLambda(arguments[0]) ? PhpConvertArrayMapToLoopQuickFix.getFunctionName(arguments[0]) : null, iteratedArray);
        if (foreachBody == null) {
            return null;
        }
        String template = String.format("foreach(%s as $key => %s){%s}", iteratedArray, valueText, foreachBody);
        return PhpPsiElementFactory.createFromText(project, ForeachStatement.class, template);
    }

    public static String getFunctionName(PsiElement element) {
        if (element instanceof StringLiteralExpression) {
            return ((StringLiteralExpression)element).getContents();
        }
        if (element instanceof Variable) {
            return element.getText();
        }
        return null;
    }

    @Nullable
    public static Function resolveFunction(PsiElement element) {
        PsiReference[] references;
        if (PhpArrayFilterCanBeConvertedToLoopInspection.canBeCalledAsLambda(element) && (references = element.getReferences()).length == 1) {
            return (Function)ObjectUtils.tryCast((Object)references[0].resolve(), Function.class);
        }
        return (Function)PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)Function.INSTANCEOF);
    }

    @Contract(value="null, _, _, _ -> null")
    @Nullable
    private static String getForeachBody(@Nullable GroupStatement closureBody, @NotNull String declaredArrayName, @Nullable String functionName, @NotNull String iteratedArray) {
        String pushedValue;
        String bodyText;
        List statements;
        if (declaredArrayName == null) {
            PhpConvertArrayMapToLoopQuickFix.$$$reportNull$$$0(7);
        }
        if (iteratedArray == null) {
            PhpConvertArrayMapToLoopQuickFix.$$$reportNull$$$0(8);
        }
        List list = statements = closureBody != null ? ContainerUtil.filter((Object[])closureBody.getStatements(), (Condition)Statement.INSTANCEOF) : Collections.emptyList();
        if (functionName == null) {
            bodyText = ((StreamEx)StreamEx.of((Collection)statements).limit((long)Math.max(0, statements.size() - 1))).map(PsiElement::getText).joining((CharSequence)"\n");
            PhpReturn phpReturn = (PhpReturn)ObjectUtils.tryCast((Object)ContainerUtil.getLastItem((List)statements), PhpReturn.class);
            PsiElement returnValue = phpReturn != null ? phpReturn.getArgument() : null;
            pushedValue = returnValue != null ? returnValue.getText() : null;
        } else {
            bodyText = "";
            pushedValue = String.format("%s(%s[$key])", functionName, iteratedArray);
        }
        return pushedValue != null ? String.format("%s\n$%s[$key] = %s;", bodyText, declaredArrayName, pushedValue) : null;
    }

    @Nls
    public static String getNameText() {
        return PhpBundle.message("quickfix.convert.arraymap.to.loop", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpConvertArrayMapToLoopQuickFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayMapCall";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredArrayName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iteratedArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpConvertArrayMapToLoopQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createForeach";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getForeachBody";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

