/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeMethodModifiersQuickFix
extends PhpQuickFixBase {
    public static final LocalQuickFix CHANGE_TO_PUBLIC_STATIC = new PhpChangeMethodModifiersQuickFix(PhpModifier.PUBLIC_IMPLEMENTED_STATIC);
    public static final LocalQuickFix CHANGE_TO_PUBLIC = new PhpChangeMethodModifiersQuickFix(PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC);
    private final PhpModifier myModifier;

    public PhpChangeMethodModifiersQuickFix(@Nullable PhpModifier modifier) {
        this.myModifier = modifier;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.myModifier != null ? PhpBundle.message("change.method.modifiers.to.0", this.myModifier.toString()) : PhpBundle.message("php.change.method.modifiers.quick.fix.text", new Object[0]);
        if (string == null) {
            PhpChangeMethodModifiersQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.change.method.modifiers.quick.fix.family.name", new Object[0]);
        if (string == null) {
            PhpChangeMethodModifiersQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Method method;
        if (project == null) {
            PhpChangeMethodModifiersQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpChangeMethodModifiersQuickFix.$$$reportNull$$$0(3);
        }
        if ((method = (Method)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)Method.INSTANCEOF)) == null) {
            return;
        }
        PhpChangeMethodModifiersQuickFix.changeMethodModifier(method, this.myModifier);
    }

    public static void changeMethodModifier(@NotNull Method method, PhpModifier modifier) {
        if (method == null) {
            PhpChangeMethodModifiersQuickFix.$$$reportNull$$$0(4);
        }
        Object oldModifierList = PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)((Condition)PhpModifierList.class::isInstance));
        if (oldModifierList == null) {
            return;
        }
        String methodText = (modifier != null ? modifier.toString() : "") + " function foo();";
        PsiElement newModifierList = PhpPsiElementFactory.createMethod(method.getProject(), methodText).getFirstChild();
        oldModifierList.replace(newModifierList);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpChangeMethodModifiersQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpChangeMethodModifiersQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "changeMethodModifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

