/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.intentions.PhpReplaceWithAliasIntention;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpBaseImportQuickFix<E extends PhpNamedElement>
extends PhpQuickFixBase {
    private static final PhpNamedElement[] NAMED_ELEMENT_EMPTY_ARRAY = new PhpNamedElement[0];

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        PhpReference classReference;
        if (project == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(1);
        }
        if ((classReference = PhpBaseImportQuickFix.getReference(element = descriptor.getPsiElement())) == null) {
            return;
        }
        PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)classReference);
        if (scopeForUseOperator == null) {
            return;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            this.showIsInDumpModeMessage(project, element);
            return;
        }
        Collection<E> candidates = this.getCandidates(project, classReference);
        Collection<PhpUse> aliasesCandidates = this.getImportedAliasesCandidates(PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)classReference), candidates);
        SmartList allCandidates = new SmartList();
        allCandidates.addAll(aliasesCandidates);
        allCandidates.addAll(candidates);
        if (allCandidates.isEmpty()) {
            PhpBaseImportQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.import.base.no.candidates", new Object[0]), element);
            return;
        }
        if (allCandidates.size() > 1) {
            Editor editor = PsiEditorUtil.findEditor((PsiElement)classReference);
            if (editor == null) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.applyFix(project, classReference, (PhpNamedElement)allCandidates.iterator().next());
                return;
            }
            NavigationUtil.getPsiElementPopup((PsiElement[])allCandidates.toArray(NAMED_ELEMENT_EMPTY_ARRAY), (PsiElementListCellRenderer)new PsiElementListCellRenderer<PhpNamedElement>(){

                public String getElementText(PhpNamedElement e) {
                    String presentableFQN = PhpLangUtil.toPresentableFQN(e.getFQN());
                    return e instanceof PhpUse ? presentableFQN + " (" + e.getName() + ")" : presentableFQN;
                }

                @Nullable
                protected String getContainerText(PhpNamedElement element1, String name) {
                    return null;
                }

                protected int getIconFlags() {
                    return 0;
                }
            }, (String)this.getImportPopupTitle(), (PsiElementProcessor)new PsiElementProcessor<PhpNamedElement>(){

                public boolean execute(@NotNull PhpNamedElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> PhpBaseImportQuickFix.this.applyFix(project, classReference, element)), PhpBaseImportQuickFix.this.getCommandName(), (Object)this);
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/inspections/quickfix/PhpBaseImportQuickFix$2", "execute"));
                }
            }).showInBestPositionFor(editor);
        } else {
            this.applyFix(project, classReference, (PhpNamedElement)candidates.iterator().next());
        }
    }

    @NotNull
    @NlsContexts.Command
    protected abstract String getCommandName();

    @Nullable
    public static PhpReference getReference(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(2);
        }
        if (!((parent = element.getParent()) instanceof PhpReference)) {
            return null;
        }
        return (PhpReference)parent;
    }

    @NotNull
    @NlsContexts.PopupTitle
    protected abstract String getImportPopupTitle();

    public void applyFix(@NotNull Project project, @NotNull PhpReference referenceToImport, @NotNull PhpNamedElement definition) {
        if (project == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(3);
        }
        if (referenceToImport == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(4);
        }
        if (definition == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(5);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)referenceToImport)) {
            return;
        }
        if (definition instanceof PhpUse) {
            PhpReplaceWithAliasIntention.replaceReference(project, (PsiReference)referenceToImport, definition.getName());
            return;
        }
        String fqn = definition.getFQN();
        if (!PhpLangUtil.isFqn(fqn)) {
            return;
        }
        PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)referenceToImport);
        if (scopeForUseOperator == null) {
            return;
        }
        PhpGroupUseElement.PhpUseKeyword useKeyword = PhpBaseImportQuickFix.getKeyword(referenceToImport);
        PhpUseList useList = PhpUseImpl.getUseList((PsiElement)referenceToImport);
        if (useList != null && !useList.isTraitImport()) {
            PhpNamespaceReference namespaceReference = useList.getNamespaceReference();
            if (namespaceReference == null) {
                this.replaceReference(project, referenceToImport, fqn);
            } else {
                String globalName = PhpLangUtil.toFQN(namespaceReference.getFullName());
                if (fqn.startsWith(globalName)) {
                    this.replaceReference(project, referenceToImport, fqn.substring(globalName.length()));
                } else {
                    this.importIfNeeded(scopeForUseOperator, fqn, useKeyword);
                    PhpUse use = (PhpUse)PhpPsiUtil.getParentByCondition((PsiElement)referenceToImport, true, (Condition<? super PsiElement>)PhpUse.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                    PhpCodeEditUtil.deleteUseOrUseList(use, useList);
                }
            }
        } else {
            this.importIfNeeded(scopeForUseOperator, fqn, useKeyword);
        }
    }

    private void importIfNeeded(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn, PhpGroupUseElement.PhpUseKeyword keyword) {
        if (scopeForUseOperator == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(6);
        }
        if (fqn == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(7);
        }
        String alias = PhpCodeInsightUtil.findImportedName(scopeForUseOperator, fqn, keyword);
        if (!PhpCodeInsightUtil.isSameNamespace(scopeForUseOperator, fqn) && !PhpLangUtil.equalsClassNames(alias, PhpLangUtil.toShortName(fqn))) {
            PhpAliasImporter.insertUseStatementWithKeyword(this.getImportKeyword(), fqn, null, scopeForUseOperator);
        }
    }

    @Nullable
    protected abstract String getImportKeyword();

    protected abstract void replaceReference(@NotNull Project var1, @NotNull PhpReference var2, @NotNull String var3);

    @NotNull
    public abstract Collection<E> getCandidates(@NotNull Project var1, @NotNull PhpReference var2);

    @NotNull
    private Collection<PhpUse> getImportedAliasesCandidates(@Nullable PhpPsiElement scope, @NotNull Collection<E> candidates) {
        if (candidates == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            List<PhpUse> list = Collections.emptyList();
            if (list == null) {
                PhpBaseImportQuickFix.$$$reportNull$$$0(9);
            }
            return list;
        }
        THashSet candidatesFqns = new THashSet((Collection)ContainerUtil.map(candidates, PhpNamedElement::getFQN), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        SmartList result = new SmartList();
        for (PhpUseList anImport : PhpCodeInsightUtil.collectImports(scope)) {
            for (PhpUse declaration : anImport.getDeclarations()) {
                String importKeyword = StringUtil.nullize((String)PhpGroupUseElement.getKeyword(declaration, anImport));
                if (declaration.getAliasName() == null || !candidatesFqns.contains((Object)declaration.getFQN()) || !StringUtil.equalsIgnoreCase((CharSequence)importKeyword, (CharSequence)this.getImportKeyword())) continue;
                result.add(declaration);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    public static PhpGroupUseElement.PhpUseKeyword getKeyword(PhpReference element) {
        if (element instanceof FunctionReference) {
            return PhpGroupUseElement.PhpUseKeyword.FUNCTION;
        }
        if (element instanceof ConstantReference) {
            return PhpGroupUseElement.PhpUseKeyword.CONSTANT;
        }
        return PhpGroupUseElement.PhpUseKeyword.CLASS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceToImport";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForUseOperator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpBaseImportQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpBaseImportQuickFix";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedAliasesCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "importIfNeeded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getImportedAliasesCandidates";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

