/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocThrowsTag;
import com.jetbrains.php.lang.inspections.probablyBug.PhpUnhandledExceptionInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddTagBaseQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/php/lang/inspections/quickfix/PhpAddThrowsTagQuickFix;", "Lcom/jetbrains/php/lang/inspections/quickfix/PhpAddTagBaseQuickFix;", "Lcom/jetbrains/php/lang/psi/elements/Function;", "exception", "Lcom/jetbrains/php/lang/psi/resolve/types/PhpType;", "(Lcom/jetbrains/php/lang/psi/resolve/types/PhpType;)V", "getDocComment", "Lcom/jetbrains/php/lang/documentation/phpdoc/psi/PhpDocComment;", "element", "Lcom/intellij/psi/PsiElement;", "getOwner", "getTag", "project", "Lcom/intellij/openapi/project/Project;", "owner", "getTagName", "", "intellij.php.impl"})
public final class PhpAddThrowsTagQuickFix
extends PhpAddTagBaseQuickFix<Function> {
    private final PhpType exception;

    @Override
    @NotNull
    protected String getTagName() {
        return "@throws";
    }

    @Override
    @NotNull
    public Function getOwner(@NotNull PsiElement element) {
        Function function;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PhpDocComment) {
            PsiElement psiElement = ((PhpDocComment)element).getOwner();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.Function");
            }
            function = (Function)psiElement;
        } else {
            Object t = PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)Function.INSTANCEOF);
            Intrinsics.checkNotNull(t);
            function = (Function)t;
        }
        return function;
    }

    @Override
    @NotNull
    protected PhpDocComment getDocComment(@NotNull PsiElement element) {
        PhpDocComment phpDocComment;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (!(psiElement instanceof PhpDocComment)) {
            psiElement = null;
        }
        if ((phpDocComment = (PhpDocComment)psiElement) == null) {
            Object t = PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)Function.INSTANCEOF);
            Intrinsics.checkNotNull(t);
            Intrinsics.checkNotNullExpressionValue(t, (String)"PhpPsiUtil.getParentByCo\u2026   Function.INSTANCEOF)!!");
            PhpDocComment phpDocComment2 = PhpUnhandledExceptionInspection.Companion.getDocCommentToAddException((Function)t);
            phpDocComment = phpDocComment2;
            Intrinsics.checkNotNull((Object)phpDocComment2);
        }
        return phpDocComment;
    }

    @Override
    @NotNull
    public PsiElement getTag(@NotNull Project project, @NotNull Function owner, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = PhpDocUtil.getTypePresentation(project, this.exception, PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)owner));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PhpDocUtil.getTypePresen\u2026opeForUseOperator(owner))");
        String typePresentation = string;
        String template = "/**\n* @throws " + typePresentation + "\n*/";
        PhpDocThrowsTag phpDocThrowsTag = PhpPsiElementFactory.createFromText(project, PhpDocThrowsTag.class, template);
        Intrinsics.checkNotNull((Object)phpDocThrowsTag);
        return phpDocThrowsTag;
    }

    public PhpAddThrowsTagQuickFix(@NotNull PhpType exception2) {
        Intrinsics.checkNotNullParameter((Object)exception2, (String)"exception");
        this.exception = exception2;
    }
}

