/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpAddTagBaseQuickFix<Owner extends PsiElement>
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.add.tag.base.quick.fix.family.name", this.getTagName());
        if (string == null) {
            PhpAddTagBaseQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected abstract String getTagName();

    @NotNull
    public abstract Owner getOwner(@NotNull PsiElement var1);

    @NotNull
    protected abstract PhpDocComment getDocComment(@NotNull PsiElement var1);

    @NotNull
    public abstract PsiElement getTag(@NotNull Project var1, @NotNull Owner var2, @NotNull PsiElement var3);

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpAddTagBaseQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpAddTagBaseQuickFix.$$$reportNull$$$0(2);
        }
        PsiElement element = descriptor.getPsiElement();
        PsiFile psiFile = element.getContainingFile();
        Owner owner = this.getOwner(element);
        PhpDocComment docComment = this.getDocComment(element);
        PsiElement retTag = this.getTag(project, owner, element);
        PsiElement star = PhpPsiUtil.findPrevSiblingOfAnyType(retTag, PhpDocTokenTypes.DOC_LEADING_ASTERISK);
        assert (star != null);
        PsiElement lineFeed = star.getPrevSibling();
        PsiElement insertAfter = this.findTagPlace(docComment, (PsiElement)owner);
        if (insertAfter == null) {
            return;
        }
        int offset = insertAfter.getTextRange().getStartOffset();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        Document document = manager.getDocument(psiFile);
        PsiElement insertedLF = null;
        if (insertAfter instanceof PsiWhiteSpace && !insertAfter.textContains('\n') && lineFeed != null) {
            insertedLF = docComment.addAfter(lineFeed, insertAfter);
        }
        retTag = docComment.addAfter(retTag, insertedLF == null ? insertAfter : insertedLF);
        if (lineFeed != null) {
            docComment.addAfter(lineFeed, retTag);
        }
        docComment.addBefore(star, retTag);
        if (document != null) {
            manager.doPostponedOperationsAndUnblockDocument(document);
            PhpDocComment updatedComment = (PhpDocComment)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(offset), PhpDocComment.class);
            if (updatedComment != null) {
                TextRange reformatRange = updatedComment.getTextRange();
                CodeStyleManager.getInstance((Project)project).reformatText(psiFile, reformatRange.getStartOffset(), reformatRange.getEndOffset());
            }
        }
    }

    @Nullable
    private PsiElement findTagPlace(@NotNull PhpDocComment docComment, @NotNull PsiElement function) {
        if (docComment == null) {
            PhpAddTagBaseQuickFix.$$$reportNull$$$0(3);
        }
        if (function == null) {
            PhpAddTagBaseQuickFix.$$$reportNull$$$0(4);
        }
        PsiElement anchor = null;
        Collection<PhpDocCommentGenerator.AnchorInfo> anchorInfoList = PhpDocCommentGenerator.getAnchorInfoList(function);
        boolean afterRetTag = false;
        for (PhpDocCommentGenerator.AnchorInfo anchorInfo : anchorInfoList) {
            if (this.getTagName().equals(anchorInfo.tagName)) {
                afterRetTag = true;
                continue;
            }
            if (!afterRetTag || (anchor = PhpAddTagBaseQuickFix.findAnchorElement((PsiElement)docComment, anchorInfo.tagName)) == null) continue;
            break;
        }
        if (anchor == null) {
            String tagName = "@method".equals(this.getTagName()) ? StringUtil.trimStart((String)this.getTagName(), (String)"@") : this.getTagName();
            anchor = (PsiElement)ArrayUtil.getLastElement((Object[])docComment.getTagElementsByName(tagName));
        }
        if (anchor == null) {
            anchor = PhpPsiUtil.getChildOfType((PsiElement)docComment, PhpDocTokenTypes.DOC_COMMENT_END);
        }
        if (PhpPsiUtil.isOfType(anchor, PhpDocTokenTypes.DOC_LEADING_ASTERISK, PhpDocTokenTypes.DOC_COMMENT_END)) {
            anchor = anchor.getPrevSibling();
        }
        return anchor;
    }

    private static PsiElement findAnchorElement(@NotNull PsiElement docComment, @NotNull String anchorText) {
        if (docComment == null) {
            PhpAddTagBaseQuickFix.$$$reportNull$$$0(5);
        }
        if (anchorText == null) {
            PhpAddTagBaseQuickFix.$$$reportNull$$$0(6);
        }
        PsiElement anchor = null;
        String originalText = docComment.getText();
        int anchorPos = originalText.indexOf(anchorText);
        if (anchorPos > 0) {
            anchor = docComment.findElementAt(anchorPos + 1);
            if (PhpPsiUtil.isOfType(anchor, PhpDocTokenTypes.DOC_TAG_NAME)) {
                if ((anchor = anchor.getParent()) != null) {
                    anchor = anchor.getPrevSibling();
                }
                if (anchor instanceof PsiWhiteSpace) {
                    anchor = anchor.getPrevSibling();
                }
            } else {
                anchor = null;
            }
        }
        return anchor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddTagBaseQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddTagBaseQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTagPlace";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAnchorElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

