/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethodTag;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddTagBaseQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpParameterInfo;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpAddMethodTagQuickFix
extends PhpAddTagBaseQuickFix<PhpClass>
implements LowPriorityAction {
    public static final PhpAddMethodTagQuickFix INSTANCE = new PhpAddMethodTagQuickFix();

    private PhpAddMethodTagQuickFix() {
    }

    @Override
    @NotNull
    protected String getTagName() {
        return "@method";
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        MemberReference memberReference;
        if (project == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(1);
        }
        if ((memberReference = (MemberReference)PhpPsiUtil.getParentByCondition(element = descriptor.getPsiElement(), (Condition<? super PsiElement>)MemberReference.INSTANCEOF)) == null) {
            return;
        }
        if (PhpAddMethodDeclarationQuickFix.findClassWithValidation(project, element, memberReference) == null) {
            return;
        }
        WriteAction.run(() -> super.applyFix(project, descriptor));
    }

    @Override
    @NotNull
    public PhpClass getOwner(@NotNull PsiElement element) {
        if (element == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(2);
        }
        PhpClass phpClass = PhpAddMethodTagQuickFix.findClass(element);
        if (phpClass == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(3);
        }
        return phpClass;
    }

    @Override
    @NotNull
    protected PhpDocComment getDocComment(@NotNull PsiElement element) {
        if (element == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(4);
        }
        PhpClass phpClass = PhpAddMethodTagQuickFix.findClass(element);
        assert (phpClass != null);
        PhpDocComment docComment = phpClass.getDocComment();
        if (docComment == null) {
            docComment = PhpPsiElementFactory.createPhpPsiFromText(element.getProject(), PhpDocComment.class, "/**\n */");
            docComment = (PhpDocComment)phpClass.getParent().addBefore((PsiElement)docComment, (PsiElement)phpClass);
        }
        PhpDocComment phpDocComment = docComment;
        if (phpDocComment == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(5);
        }
        return phpDocComment;
    }

    @Nullable
    private static PhpClass findClass(@NotNull PsiElement element) {
        if (element == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(6);
        }
        return PhpQuickFixBase.resolveClass((MemberReference)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)MemberReference.INSTANCEOF), false);
    }

    @Override
    @NotNull
    public PsiElement getTag(@NotNull Project project, @NotNull PhpClass phpClass, @NotNull PsiElement element) {
        if (project == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(7);
        }
        if (phpClass == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(8);
        }
        if (element == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(9);
        }
        StringBuilder builder = new StringBuilder("/**\n * @method ");
        MemberReference memberReference = (MemberReference)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)MemberReference.INSTANCEOF);
        assert (memberReference != null);
        if (memberReference.getReferenceType().isStatic()) {
            builder.append("static ");
        }
        builder.append(element.getText());
        Collection<PhpParameterInfo> infos = PhpAddMethodDeclarationQuickFix.getParametersInfos((PhpExpression)memberReference);
        builder.append(PhpAddMethodDeclarationQuickFix.makeParameterList(project, infos, (PsiElement)phpClass, true, true));
        builder.append("\n */");
        PhpDocMethodTag phpDocMethodTag = PhpPsiElementFactory.createPhpPsiFromText(project, PhpDocMethodTag.class, builder.toString());
        if (phpDocMethodTag == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(10);
        }
        return phpDocMethodTag;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddMethodTagQuickFix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddMethodTagQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocComment";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOwner";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDocComment";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

