/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.google.common.base.Predicates;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddFieldDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpParameterInfo;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpNameSuggestionUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddMethodDeclarationQuickFix
extends PhpQuickFixBase {
    public static final PhpAddMethodDeclarationQuickFix INSTANCE = new PhpAddMethodDeclarationQuickFix();
    private static final Predicate<String> NOT_PARAMETER_TYPE_HINT = Predicates.or((com.google.common.base.Predicate[])new com.google.common.base.Predicate[]{PhpType::isAnonymousClass, "static"::equalsIgnoreCase, "$this"::equalsIgnoreCase, "this"::equalsIgnoreCase});

    protected PhpAddMethodDeclarationQuickFix() {
    }

    @NotNull
    public String getName() {
        String string = PhpBundle.message("php.add.method.declaration.quick.fix.text", new Object[0]);
        if (string == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        MemberReference reference;
        if (project == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(3);
        }
        if ((reference = (MemberReference)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor.getPsiElement()), MemberReference.class, (boolean)false)) == null) {
            return;
        }
        PhpClass klass = PhpAddMethodDeclarationQuickFix.findClassWithValidation(project, element, reference);
        if (klass == null) {
            return;
        }
        WriteAction.run(() -> {
            boolean staticRef = reference.getReferenceType().isStatic();
            Collection<PhpParameterInfo> infos = PhpAddMethodDeclarationQuickFix.getParametersInfos((PhpExpression)reference);
            Method method = (Method)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)PhpAddMethodDeclarationQuickFix.buildMethod(element, PhpAddMethodDeclarationQuickFix.makeParameterList(project, infos, (PsiElement)klass, false, true), element.getText(), staticRef, klass));
            PhpClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PhpAddMethodDeclarationQuickFix.runMethodTemplate(project, method, containingClass, infos);
        });
    }

    private static void runMethodTemplate(final @NotNull Project project, @NotNull Method method, @NotNull PhpClass klass, Collection<PhpParameterInfo> infos) {
        if (project == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(4);
        }
        if (method == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(5);
        }
        if (klass == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(6);
        }
        PhpAddFieldDeclarationQuickFix.runTemplate((PsiElement)method, PhpAddMethodDeclarationQuickFix.createTemplate(method, klass, infos), (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template1, boolean brokenOff) {
                if (template1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!brokenOff) {
                    PhpCodeEditUtil.setupMethodBody(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template1", "com/jetbrains/php/lang/inspections/quickfix/PhpAddMethodDeclarationQuickFix$1", "templateFinished"));
            }
        });
    }

    @NotNull
    private static Template createTemplate(@NotNull Method method, @NotNull PhpClass clazz, @NotNull Collection<PhpParameterInfo> infos) {
        if (method == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(7);
        }
        if (clazz == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(8);
        }
        if (infos == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(9);
        }
        Map infosMap = StreamEx.of(infos).toMap(PhpParameterInfo::getName, Function.identity());
        Project project = method.getProject();
        TemplateBuilderImpl templateBuilder = PhpAddFieldDeclarationQuickFix.replaceModifierElementBuilder((PsiElement)method);
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)clazz);
        for (Parameter parameter : method.getParameters()) {
            PsiElement parameterTypeNode;
            Collection<String> possibleTypeHints;
            PhpParameterInfo info = (PhpParameterInfo)infosMap.get(parameter.getName());
            if (info == null || (possibleTypeHints = info.getTypeHints(project, scope)).size() <= 1 || (parameterTypeNode = PhpAddMethodDeclarationQuickFix.getParameterTypeNode(parameter)) == null) continue;
            templateBuilder.replaceElement(parameterTypeNode, (Expression)new ConstantNode((String)ContainerUtil.getFirstItem(possibleTypeHints)).withLookupStrings(possibleTypeHints));
        }
        Template template = templateBuilder.buildTemplate();
        if (template == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(10);
        }
        return template;
    }

    @Nullable
    private static PsiElement getParameterTypeNode(Parameter parameter) {
        PhpTypeDeclaration child = (PhpTypeDeclaration)PhpPsiUtil.getChildByCondition((PsiElement)parameter, (Condition<? super PsiElement>)((Condition)PhpTypeDeclaration.class::isInstance));
        if (child != null) {
            if (child.isNullable()) {
                return (PsiElement)ContainerUtil.getFirstItem((Collection)child.getClassReferences());
            }
            return child.getFirstChild();
        }
        return null;
    }

    @Nullable
    static PhpClass findClassWithValidation(@NotNull Project project, @NotNull PsiElement element, @NotNull MemberReference reference) {
        PhpClass klass;
        if (project == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(11);
        }
        if (element == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(12);
        }
        if (reference == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(13);
        }
        if ((klass = PhpAddMethodDeclarationQuickFix.resolveClassWithErrorReporting(project, reference, false)) == null || !FileModificationService.getInstance().prepareFileForWrite(klass.getContainingFile())) {
            return null;
        }
        String error = PhpAddMethodDeclarationQuickFix.validateClass(project, klass);
        if (StringUtil.isNotEmpty((String)error)) {
            PhpAddMethodDeclarationQuickFix.showErrorMessage(project, error, element);
            return null;
        }
        return klass;
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected static Method buildMethod(PsiElement element, String parameterList, String functionName, boolean staticRef, @NotNull PhpClass klass) {
        if (klass == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(14);
        }
        StringBuilder template = new StringBuilder();
        if (PhpCodeUtil.belongsTo(element, (PsiElement)klass)) {
            template.append("private");
        } else {
            template.append("public");
        }
        template.append(" ");
        template.append(staticRef ? "static " : "");
        template.append("function ");
        template.append(functionName);
        template.append(parameterList);
        if (klass.isInterface()) {
            template.append(";");
        } else {
            template.append("{\n}");
        }
        Method templateMethod = PhpCodeUtil.createMethodFromTemplate(klass, klass.getProject(), template.toString());
        assert (templateMethod != null);
        PsiElement inserted = PhpCodeEditUtil.insertClassMember(klass, (PsiElement)templateMethod);
        return (Method)inserted;
    }

    @NotNull
    public static Collection<PhpParameterInfo> getParametersInfos(PhpExpression ref) {
        SmartList result = new SmartList();
        List paramLists = PhpPsiUtil.getChildren((PsiElement)ref, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
        THashSet parametersNames = new THashSet();
        if (!paramLists.isEmpty()) {
            ParameterList paramList = (ParameterList)paramLists.get(paramLists.size() - 1);
            for (PhpPsiElement child = paramList.getFirstPsiChild(); child != null; child = child.getNextSibling()) {
                ASTNode childNode = child.getNode();
                if (childNode == null || child instanceof PsiWhiteSpace || PhpPsiUtil.isOfType((PsiElement)child, PhpTokenTypes.opCOMMA)) continue;
                String parameterName = PhpAddMethodDeclarationQuickFix.suggestParameterName((Set<String>)parametersNames, (PsiElement)child);
                result.add(PhpAddMethodDeclarationQuickFix.createParameterTypeInfo(child.getProject(), new PhpType().add((PsiElement)child).global(child.getProject()), parameterName));
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(15);
        }
        return smartList;
    }

    @NotNull
    public static PhpParameterInfo createParameterTypeInfo(@NotNull Project project, @NotNull PhpType type, @NotNull String parameterName) {
        if (project == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(16);
        }
        if (type == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(17);
        }
        if (parameterName == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(18);
        }
        if (type.isEmpty()) {
            return new PhpParameterInfo(parameterName);
        }
        PhpType suitableType = PhpAddMethodDeclarationQuickFix.collectSuitableForParameterTypeHint(project, type);
        boolean nullable = suitableType.isNullable();
        return new PhpParameterInfo(parameterName, (Collection<String>)new SmartList((Collection)suitableType.filterNull().getTypes()), nullable);
    }

    @NotNull
    public static String makeParameterList(Project project, @NotNull Collection<PhpParameterInfo> parameterInfos, @Nullable PsiElement context, boolean phpDocMethod, boolean allowMultipleTypes) {
        if (parameterInfos == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(19);
        }
        PhpPsiElement scope = context != null ? PhpCodeInsightUtil.findScopeForUseOperator(context) : null;
        String parameters = StreamEx.of(parameterInfos).map(info -> PhpAddMethodDeclarationQuickFix.createParameterTypeHint(project, info, scope, phpDocMethod, allowMultipleTypes) + "$" + info.getName()).joining((CharSequence)",");
        String string = "(" + parameters + ")";
        if (string == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String createParameterTypeHint(Project project, @NotNull PhpType type, PhpPsiElement scope, boolean phpDocMethod, boolean allowMultipleTypes) {
        if (type == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(21);
        }
        PhpParameterInfo info = new PhpParameterInfo("", (Collection<String>)new SmartList((Collection)type.filterNull().getTypes()), type.isNullable());
        return PhpAddMethodDeclarationQuickFix.createParameterTypeHint(project, info, scope, phpDocMethod, allowMultipleTypes);
    }

    @NotNull
    public static String createParameterTypeHint(Project project, @NotNull PhpParameterInfo info, PhpPsiElement scope, boolean phpDocMethod, boolean allowMultipleTypes) {
        String typeHintString;
        if (info == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(22);
        }
        if (phpDocMethod) {
            String string = PhpDocUtil.getTypePresentation(project, info.createType(), scope);
            if (string == null) {
                PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(23);
            }
            return string;
        }
        Collection<String> typeHints = info.getTypeHints(project, scope);
        StringBuilder res = new StringBuilder();
        if (!typeHints.isEmpty() && (typeHintString = PhpCodeUtil.getTypeHintString(project, allowMultipleTypes, typeHints)) != null) {
            boolean isUnionType;
            boolean bl = isUnionType = typeHintString.contains("|") && PhpLanguageFeature.UNION_TYPES.isSupported(project);
            if (!isUnionType && PhpLanguageFeature.NULLABLES.isSupported(project) && info.isNullable()) {
                res.append("?");
            }
            res.append(typeHintString);
            if (isUnionType && PhpLanguageFeature.NULLABLES.isSupported(project) && info.isNullable()) {
                res.append("|null");
            }
        }
        String string = res.toString();
        if (string == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static PhpType collectSuitableForParameterTypeHint(@NotNull Project project, @NotNull PhpType type) {
        String onlyType;
        if (project == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(25);
        }
        if (type == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(26);
        }
        PhpType result = type.filterUnknown();
        if (PhpLanguageFeature.OBJECT_TYPE_HINT.isSupported(project) && (onlyType = (String)ContainerUtil.getOnlyItem((Collection)result.filterMixed().getTypes())) != null && PhpType.isAnonymousClass((String)onlyType)) {
            PhpType phpType = new PhpType().add(PhpType.OBJECT.toString());
            if (phpType == null) {
                PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(27);
            }
            return phpType;
        }
        if (PhpLanguageFeature.MIXED_TYPE_HINT.isSupported(project) && PhpType.intersects((PhpType)type, (PhpType)PhpType.MIXED)) {
            PhpType phpType = PhpType.MIXED;
            if (phpType == null) {
                PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(28);
            }
            return phpType;
        }
        PhpType phpType = result.filterOut(NOT_PARAMETER_TYPE_HINT);
        if (phpType == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(29);
        }
        return phpType;
    }

    public static String getParameterDoc(PhpExpression ref) {
        StringBuilder sb = new StringBuilder();
        THashSet parametersNames = new THashSet();
        List paramLists = PhpPsiUtil.getChildren((PsiElement)ref, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
        if (!paramLists.isEmpty()) {
            ParameterList paramList = (ParameterList)paramLists.get(paramLists.size() - 1);
            PhpPsiElement child = paramList.getFirstPsiChild();
            while (child != null) {
                ASTNode childNode = child.getNode();
                if (childNode == null) continue;
                IElementType childType = childNode.getElementType();
                if (childType == PhpTokenTypes.opCOMMA) {
                    sb.append('\n');
                } else if (child instanceof PhpExpression) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append("* ").append("@param ");
                    String typeStr = PhpDocUtil.getTypePresentation(ref.getProject(), ((PhpExpression)child).getType(), PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)child));
                    if (!typeStr.isEmpty()) {
                        sb.append(typeStr).append(' ');
                    }
                    String parameterName = PhpAddMethodDeclarationQuickFix.suggestParameterName((Set<String>)parametersNames, (PsiElement)child);
                    sb.append('$').append(parameterName);
                }
                child = child.getNextSibling();
            }
        }
        return sb.toString();
    }

    private static String suggestParameterName(@NotNull Set<String> parametersNames, @NotNull PsiElement child) {
        Object name;
        if (parametersNames == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(30);
        }
        if (child == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(31);
        }
        if (parametersNames.contains(name = PhpNameSuggestionUtil.parameterNameByElement(child))) {
            int index = 1;
            while (parametersNames.contains((String)name + index)) {
                ++index;
            }
            name = (String)name + index;
        }
        parametersNames.add((String)name);
        return name;
    }

    @NotNull
    public static String createTypeHint(Project project, PhpType type, @Nullable PsiElement scopeHolder, boolean phpDocMethod, boolean allowMultipleTypes) {
        PhpPsiElement scope = scopeHolder != null ? PhpCodeInsightUtil.findScopeForUseOperator(scopeHolder) : null;
        PhpParameterInfo info = PhpAddMethodDeclarationQuickFix.createParameterTypeInfo(project, type, "");
        String string = StringUtil.notNullize((String)PhpAddMethodDeclarationQuickFix.createParameterTypeHint(project, info, scope, phpDocMethod, allowMultipleTypes));
        if (string == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddMethodDeclarationQuickFix";
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 17: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterInfos";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersNames";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddMethodDeclarationQuickFix";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplate";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersInfos";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "makeParameterList";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterTypeHint";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSuitableForParameterTypeHint";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeHint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runMethodTemplate";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findClassWithValidation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildMethod";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createParameterTypeInfo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "makeParameterList";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createParameterTypeHint";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectSuitableForParameterTypeHint";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "suggestParameterName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

