/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.intentions.PhpDeclareFieldIntention;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddFieldDeclarationQuickFix
extends PhpQuickFixBase {
    public static final PhpAddFieldDeclarationQuickFix INSTANCE = new PhpAddFieldDeclarationQuickFix();

    protected PhpAddFieldDeclarationQuickFix() {
    }

    @Nullable
    public static PsiElement createField(@NotNull Project project, @NotNull PhpClass klass, @NotNull String fieldName, @Nullable PhpType type, boolean staticRef) {
        if (project == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(0);
        }
        if (klass == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(1);
        }
        if (fieldName == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(2);
        }
        PhpModifier.Access access = PhpRefactoringSettings.getInstance().EXTRACT_FIELD_DEFAULT_VISIBILITY;
        if (!ModuleUtilCore.projectContainsFile((Project)project, (VirtualFile)klass.getContainingFile().getVirtualFile(), (boolean)false)) {
            Messages.showErrorDialog((Project)project, (String)PhpBundle.message("the.original.class.0.does.not.belong.to.the.project.and.cannot.be.modified", klass.getName()), (String)PhpBundle.message("quick.fix.error", new Object[0]));
            return null;
        }
        PhpModifier modifier = PhpModifier.instance((PhpModifier.Access)access, (PhpModifier.Abstractness)PhpModifier.Abstractness.IMPLEMENTED, (PhpModifier.State)(staticRef ? PhpModifier.State.STATIC : PhpModifier.State.DYNAMIC));
        return PhpPsiElementFactory.createClassField(project, modifier, fieldName, null, PhpRefactoringUtil.createFieldTypeDeclaration(project, type, (PsiElement)klass));
    }

    @Nullable
    public static PsiElement addFieldToClass(@NotNull PhpClass klass, @Nullable PsiElement field, @Nullable PhpDocComment docComment) {
        if (klass == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(3);
        }
        if (field != null && FileModificationService.getInstance().prepareFileForWrite(klass.getContainingFile())) {
            return (PsiElement)WriteAction.compute(() -> {
                PsiElement insertedMember = PhpCodeEditUtil.insertClassMemberWithPhpDoc(klass, field, docComment);
                return CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)insertedMember);
            });
        }
        return null;
    }

    @NotNull
    public String getName() {
        String string = PhpBundle.message("php.add.field.declaration.quick.fix.text", new Object[0]);
        if (string == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement fieldNameElement;
        MemberReference reference;
        if (project == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(7);
        }
        if ((reference = (MemberReference)PsiTreeUtil.getParentOfType((PsiElement)(fieldNameElement = descriptor.getPsiElement()), MemberReference.class, (boolean)false)) == null) {
            return;
        }
        PhpClass klass = PhpAddFieldDeclarationQuickFix.resolveClass(reference, true);
        if (klass != null) {
            PhpDeclareFieldIntention.insertFieldFromUsage(project, klass, reference, fieldNameElement.getText());
        }
    }

    @NotNull
    public static Template createFieldTemplate(@NotNull PsiElement field) {
        if (field == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(8);
        }
        Template template = PhpAddFieldDeclarationQuickFix.replaceModifierElementBuilder(CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)field)).buildTemplate();
        if (template == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(9);
        }
        return template;
    }

    @NotNull
    public static TemplateBuilderImpl replaceModifierElementBuilder(@NotNull PsiElement field) {
        if (field == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(10);
        }
        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl(field);
        PhpPsiElement accessElement = ((PhpPsiElement)field).getFirstPsiChild();
        if (accessElement != null) {
            templateBuilder.replaceElement((PsiElement)accessElement, accessElement.getText());
        }
        TemplateBuilderImpl templateBuilderImpl = templateBuilder;
        if (templateBuilderImpl == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(11);
        }
        return templateBuilderImpl;
    }

    public static void runTemplate(@NotNull PsiElement element, @NotNull Template template, @Nullable TemplateEditingListener listener) {
        if (element == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(12);
        }
        if (template == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(13);
        }
        Project project = element.getProject();
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return;
        }
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null) {
            return;
        }
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, vFile), true);
        if (editor != null) {
            TextRange range = element.getTextRange();
            WriteAction.run(() -> {
                editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
                editor.getCaretModel().moveToOffset(range.getStartOffset());
                TemplateManager.getInstance((Project)project).startTemplate(editor, template, listener);
            });
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddFieldDeclarationQuickFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddFieldDeclarationQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldTemplate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceModifierElementBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createField";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFieldToClass";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFieldTemplate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceModifierElementBuilder";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

