/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.probablyBug.PhpUnhandledExceptionInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddCatchClauseQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.surroundWith.PhpTryCatchSurrounder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0096\u0002\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/php/lang/inspections/quickfix/PhpAddCatchClauseQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "endElement", "intellij.php.impl"})
public final class PhpAddCatchClauseQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    public String getText() {
        String string = PhpBundle.message("add.catch.clause.quick.fix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PhpBundle.message(\"add.catch.clause.quick.fix\")");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement element, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Try try_ = (Try)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)invoke.tryStatement.1.INSTANCE));
        if (try_ == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)try_, (String)"PhpPsiUtil.getParentByCo\u2026 { it is Try }) ?: return");
        Try tryStatement2 = try_;
        Object t = PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)invoke.thrownRangeHolder.1.INSTANCE));
        if (t == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue(t, (String)"PhpPsiUtil.getParentByCo\u2026pression\n    }) ?: return");
        Object thrownRangeHolder2 = t;
        Set<PhpType> exceptionClasses = PhpUnhandledExceptionInspection.Companion.getExceptionClasses((PsiElement)thrownRangeHolder2);
        if (exceptionClasses.isEmpty()) {
            return;
        }
        List<PhpType> list = PhpTryCatchSurrounder.sortByHierarchy(new ArrayList(exceptionClasses), project);
        Intrinsics.checkNotNullExpressionValue(list, (String)"PhpTryCatchSurrounder.so\u2026ceptionClasses), project)");
        List<PhpType> sortedExceptionClasses = list;
        StringBuilder template = new StringBuilder("try{}");
        Iterator<PhpType> iterator = sortedExceptionClasses.iterator();
        while (iterator.hasNext()) {
            PhpType exception2;
            PhpType phpType = exception2 = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"exception");
            Set set = phpType.getTypes();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"exception.types");
            String fqn = (String)CollectionsKt.single((Iterable)set);
            template.append("catch(").append(fqn).append(" $e){}");
        }
        Statement statement = PhpPsiElementFactory.createStatement(project, template.toString());
        if (statement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.Try");
        }
        Catch[] catches = ((Try)statement).getCatchClauses();
        boolean fqn = false;
        List insertedCatches = new ArrayList();
        Finally finallyBlock = tryStatement2.getFinallyBlock();
        for (Catch catch_ : catches) {
            PsiElement insertedCatch;
            PsiElement psiElement = insertedCatch = finallyBlock != null ? tryStatement2.addBefore((PsiElement)catch_, (PsiElement)finallyBlock) : tryStatement2.add((PsiElement)catch_);
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.Catch");
            }
            insertedCatches.add((Catch)psiElement);
        }
        PhpTryCatchSurrounder.importClassReferences(tryStatement2, insertedCatches);
        if (editor != null) {
            Collection collection = insertedCatches;
            int n = 0;
            if (!collection.isEmpty()) {
                Collection collection2 = ((Catch)CollectionsKt.first((List)insertedCatches)).getExceptionTypes();
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"insertedCatches.first().exceptionTypes");
                Object object = CollectionsKt.first((Iterable)collection2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"insertedCatches.first().exceptionTypes.first()");
                int n2 = ((ClassReference)object).getTextOffset();
                editor.getCaretModel().moveToOffset(n2);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }
    }

    public PhpAddCatchClauseQuickFix(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
    }
}

