/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.psr12;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpModifierOrderInspection
extends PhpInspection
implements CleanupLocalInspectionTool {
    TokenSet beforeSet = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwABSTRACT, PhpTokenTypes.kwFINAL});

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpModifierOrderInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpModifierList(PhpModifierList modifierList) {
                Object[] children = modifierList.getNode().getChildren(PhpTokenTypes.tsMODIFIERS);
                if (ArrayUtil.isEmpty((Object[])children)) {
                    return;
                }
                ASTNode visibilityNode = (ASTNode)ContainerUtil.find((Object[])children, i1 -> PhpTokenTypes.tsVISIBILITY_MODIFIERS.contains(i1.getElementType()));
                ASTNode staticNode = (ASTNode)ContainerUtil.find((Object[])children, i -> PhpTokenTypes.kwSTATIC.equals(i.getElementType()));
                boolean wrongOrder = false;
                for (int i2 = 0; i2 < children.length; ++i2) {
                    IElementType elementType = children[i2].getElementType();
                    if (!(PhpModifierOrderInspection.this.beforeSet.contains(elementType) && (visibilityNode != null && i2 > ArrayUtil.indexOf((Object[])children, (Object)visibilityNode) || staticNode != null && i2 > ArrayUtil.indexOf((Object[])children, (Object)staticNode))) && (elementType != PhpTokenTypes.kwSTATIC || visibilityNode == null || i2 >= ArrayUtil.indexOf((Object[])children, (Object)visibilityNode))) continue;
                    wrongOrder = true;
                }
                if (wrongOrder) {
                    holder.registerProblem((PsiElement)modifierList, PhpBundle.message("inspection.message.psr.order.modifiers.incorrect", new Object[0]), new LocalQuickFix[]{new PhpFixModifierOrderQuickFix(modifierList)});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/psr12/PhpModifierOrderInspection", "buildVisitor"));
    }

    private static final class PhpFixModifierOrderQuickFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PhpModifierList> myList;

        PhpFixModifierOrderQuickFix(@NotNull PhpModifierList list) {
            if (list == null) {
                PhpFixModifierOrderQuickFix.$$$reportNull$$$0(0);
            }
            this.myList = SmartPointerManager.getInstance((Project)list.getProject()).createSmartPsiElementPointer((PsiElement)list);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("psr.12.fix.modifiers.order", new Object[0]);
            if (string == null) {
                PhpFixModifierOrderQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpModifierList element;
            if (project == null) {
                PhpFixModifierOrderQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpFixModifierOrderQuickFix.$$$reportNull$$$0(3);
            }
            if ((element = (PhpModifierList)this.myList.getElement()) != null) {
                String builder = (element.hasAbstract() ? "abstract " : "") + (element.hasFinal() ? "final " : "") + (element.hasPublic() ? "public " : "") + (element.hasPrivate() ? "private " : "") + (element.hasProtected() ? "protected " : "") + (element.hasStatic() ? "static " : "");
                PsiElement newModifierList = PhpPsiElementFactory.createMethod(this.myList.getProject(), builder + " function foo();").getFirstChild();
                element.replace(newModifierList);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/psr12/PhpModifierOrderInspection$PhpFixModifierOrderQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/psr12/PhpModifierOrderInspection$PhpFixModifierOrderQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

