/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.psr12;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.impl.ClassConstImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpMissingVisibilityInspection
extends PhpInspection
implements CleanupLocalInspectionTool {
    TokenSet visibilityModifiers = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsVISIBILITY_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwVAR})});
    private static final PhpAddPublicQuickFix QUICK_FIX = PhpAddPublicQuickFix.createInstance();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingVisibilityInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpModifierList(PhpModifierList modifierList) {
                if (ArrayUtil.isEmpty((Object[])modifierList.getNode().getChildren(PhpMissingVisibilityInspection.this.visibilityModifiers))) {
                    PsiElement parent = modifierList.getParent();
                    if (parent instanceof Method) {
                        this.registerProblem((PhpNamedElement)parent);
                    } else {
                        PsiElement siblingIgnoreWhitespace = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)modifierList, true);
                        if (siblingIgnoreWhitespace instanceof Field || siblingIgnoreWhitespace instanceof Constant) {
                            this.registerProblem((PhpNamedElement)siblingIgnoreWhitespace);
                        }
                    }
                }
            }

            public void visitPhpField(Field field) {
                if (PhpPsiUtil.getChildByCondition(field.getParent(), (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF) == null) {
                    if (field.isConstant() && !PhpProjectConfigurationFacade.getInstance(field.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP710)) {
                        return;
                    }
                    this.registerProblem((PhpNamedElement)field);
                }
            }

            private void registerProblem(PhpNamedElement element) {
                PsiElement identifier = element.getNameIdentifier();
                if (identifier != null) {
                    holder.registerProblem(identifier, PhpBundle.message("inspection.message.psr.missing.visibility.definition", new Object[0]), new LocalQuickFix[]{QUICK_FIX});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/psr12/PhpMissingVisibilityInspection", "buildVisitor"));
    }

    private static final class PhpAddPublicQuickFix
    implements LocalQuickFix {
        private static final PhpAddPublicQuickFix INSTANCE = new PhpAddPublicQuickFix();

        private PhpAddPublicQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("psr.12.add.public.visibility", new Object[0]);
            if (string == null) {
                PhpAddPublicQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Document document;
            PsiElement element;
            if (project == null) {
                PhpAddPublicQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddPublicQuickFix.$$$reportNull$$$0(2);
            }
            if (PhpPsiUtil.isOfType(element = descriptor.getPsiElement().getParent(), PhpStubElementTypes.CLASS_CONST)) {
                PsiElement value = ((ClassConstImpl)element).getDefaultValue();
                element.getParent().replace((PsiElement)PhpPsiElementFactory.createClassConstant(element.getProject(), PhpModifier.Access.PUBLIC, ((ClassConstImpl)element).getName(), StringUtil.notNullize((String)(value != null ? value.getText() : ""))));
            } else {
                element.getParent().addBefore((PsiElement)PhpPsiElementFactory.createModifierList(project, PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC), element);
            }
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile file = descriptor.getPsiElement().getContainingFile();
            if (file != null && (document = documentManager.getDocument(file)) != null) {
                documentManager.doPostponedOperationsAndUnblockDocument(document);
                PsiElement parent = element.getParent();
                if (parent.isValid()) {
                    CodeStyleManager.getInstance((Project)project).reformat(parent);
                }
            }
        }

        private static PhpAddPublicQuickFix createInstance() {
            return INSTANCE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/psr12/PhpMissingVisibilityInspection$PhpAddPublicQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/psr12/PhpMissingVisibilityInspection$PhpAddPublicQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

