/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.psr12;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpLongTypeFormInspection
extends PhpInspection
implements CleanupLocalInspectionTool {
    private static final Set<String> LONG_TYPES = ContainerUtil.newHashSet((Object[])new String[]{"integer", "boolean"});

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpLongTypeFormInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){
            private final PhpConvertToShortFormQuickFix QUICK_FIX = PhpConvertToShortFormQuickFix.createInstance();

            public void visitPhpDocType(PhpDocType type) {
                if (LONG_TYPES.contains(type.getName())) {
                    holder.registerProblem((PsiElement)type, PhpBundle.message("inspection.message.psr.short.form.type.keywords.should.be.used", new Object[0]), new LocalQuickFix[]{this.QUICK_FIX});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/psr12/PhpLongTypeFormInspection", "buildVisitor"));
    }

    private static final class PhpConvertToShortFormQuickFix
    implements LocalQuickFix {
        private PhpConvertToShortFormQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("psr.12.convert.to.short.form", new Object[0]);
            if (string == null) {
                PhpConvertToShortFormQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpConvertToShortFormQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpConvertToShortFormQuickFix.$$$reportNull$$$0(2);
            }
            descriptor.getPsiElement().replace((PsiElement)PhpPsiElementFactory.createPhpDocType(project, "integer".equals(((PhpDocType)descriptor.getPsiElement()).getName()) ? "int" : "bool"));
        }

        private static PhpConvertToShortFormQuickFix createInstance() {
            return new PhpConvertToShortFormQuickFix();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/psr12/PhpLongTypeFormInspection$PhpConvertToShortFormQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/psr12/PhpLongTypeFormInspection$PhpConvertToShortFormQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

