/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.psr0;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceProcessor;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

class FixPackagePathFix
implements LocalQuickFix {
    private final String myNewPackage;
    private String myOldPackage;

    FixPackagePathFix(String newPackage, String oldPackage) {
        this.myNewPackage = newPackage;
        this.myOldPackage = oldPackage;
    }

    @NotNull
    public String getName() {
        String string = PhpBundle.message("fix.package.text", FixPackagePathFix.fixName(this.myOldPackage), FixPackagePathFix.fixName(this.myNewPackage));
        if (string == null) {
            FixPackagePathFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String fixName(@NotNull String name) {
        if (name == null) {
            FixPackagePathFix.$$$reportNull$$$0(1);
        }
        return StringUtil.isEmpty((String)name) ? "\\" : name;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("fix.package.text.family", new Object[0]);
        if (string == null) {
            FixPackagePathFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PhpNamespace phpNamespace;
        if (project == null) {
            FixPackagePathFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            FixPackagePathFix.$$$reportNull$$$0(4);
        }
        if ((phpNamespace = (PhpNamespace)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PhpNamespace.class)) != null) {
            new PhpMoveNamespaceProcessor(project, (Collection)ContainerUtil.immutableSingletonList((Object)phpNamespace), this.myNewPackage, Collections.emptyMap(), false, false){}.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/psr0/FixPackagePathFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/psr0/FixPackagePathFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fixName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

