/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug.missingParentCall;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PhpMissingParentConstructorInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingParentConstructorInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                Collection superClassesConstructors;
                super.visitPhpClass(clazz);
                Method constructor = clazz.getOwnConstructor();
                final Ref answer = new Ref((Object)false);
                if (constructor != null && !(superClassesConstructors = (Collection)clazz.getSuperClasses().stream().map(PhpClass::getConstructor).filter(Objects::nonNull).collect(Collectors.toSet())).isEmpty() && ContainerUtil.all((Collection)superClassesConstructors, superClassConstructor -> !superClassConstructor.isAbstract() && !(superClassConstructor instanceof PhpDocMethod))) {
                    PsiElement nameIdentifier;
                    PhpControlFlowUtil.processFlow(constructor.getControlFlow(), new PhpInstructionProcessor(){

                        public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                            if (PhpMissingParentConstructorInspection.isParentConstructorCall(instruction)) {
                                answer.set((Object)true);
                                return false;
                            }
                            return true;
                        }
                    });
                    if (!((Boolean)answer.get()).booleanValue() && (nameIdentifier = constructor.getNameIdentifier()) != null && nameIdentifier.getContainingFile() == holder.getFile()) {
                        holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.missing.parent.constructor.call.message", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    private static boolean isParentConstructorCall(PhpCallInstruction instruction) {
        MethodReference functionReference = (MethodReference)ObjectUtils.tryCast((Object)instruction.getFunctionReference(), MethodReference.class);
        return functionReference != null && PhpLangUtil.equalsMethodNames(functionReference.getName(), "__construct") && PhpLangUtil.isParentReference((PsiElement)functionReference.getClassReference());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/missingParentCall/PhpMissingParentConstructorInspection", "buildVisitor"));
    }
}

