/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug.missingParentCall;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class PhpMissingParentAbstractInspection
extends PhpInspection {
    private static boolean isParentCall(PhpCallInstruction instruction, @NotNull PhpClass parent, @NotNull String name) {
        PsiElement resolve;
        MethodReference mReference;
        String mReferenceName;
        FunctionReference functionReference;
        if (parent == null) {
            PhpMissingParentAbstractInspection.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PhpMissingParentAbstractInspection.$$$reportNull$$$0(1);
        }
        if ((functionReference = instruction.getFunctionReference()) instanceof MethodReference && (mReferenceName = (mReference = (MethodReference)functionReference).getName()) != null && mReferenceName.equals(name) && (resolve = mReference.resolve()) instanceof Method) {
            PhpClass aClass = ((Method)resolve).getContainingClass();
            if (aClass != null) {
                return aClass.equals(parent);
            }
            return false;
        }
        return false;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingParentAbstractInspection.$$$reportNull$$$0(2);
        }
        return new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                super.visitPhpClass(clazz);
                Collection superClasses = clazz.getSuperClasses();
                if (superClasses.isEmpty()) {
                    return;
                }
                for (Method it : clazz.getOwnMethods()) {
                    PsiElement nameIdentifier;
                    if (!PhpMissingParentAbstractInspection.this.isMethodToCheck(it) || it instanceof PhpDocMethod) continue;
                    final String name = it.getName();
                    Collection superClassMethodsByName = superClasses.stream().map(c -> c.findMethodByName((CharSequence)name)).filter(Objects::nonNull).collect(Collectors.toList());
                    if (superClassMethodsByName.isEmpty() || !ContainerUtil.all((Collection)superClassMethodsByName, m -> !m.isAbstract() && !(m instanceof PhpDocMethod))) continue;
                    final Set superMethodClasses = superClassMethodsByName.stream().map(PhpClassMember::getContainingClass).filter(Objects::nonNull).collect(Collectors.toSet());
                    final Ref answer = new Ref((Object)false);
                    PhpControlFlowUtil.processFlow(it.getControlFlow(), new PhpInstructionProcessor(){

                        public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                            if (!superMethodClasses.isEmpty() && ContainerUtil.all((Collection)superMethodClasses, superMethodClass -> PhpMissingParentAbstractInspection.isParentCall(instruction, superMethodClass, name))) {
                                answer.set((Object)true);
                                return false;
                            }
                            return true;
                        }
                    });
                    if (((Boolean)answer.get()).booleanValue() || (nameIdentifier = it.getNameIdentifier()) == null) continue;
                    holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.missing.parent.call.message", new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
    }

    abstract boolean isMethodToCheck(Method var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/missingParentCall/PhpMissingParentAbstractInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isParentCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

