/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpDuplicateMatchConditionInspection;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnusedMatchConditionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedMatchConditionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
                PhpExpression argument = matchExpression.getArgument();
                if (argument == null) {
                    return;
                }
                PhpType argumentType = argument.getGlobalType();
                if (argumentType.isEmpty() || PhpType.intersects((PhpType)argumentType, (PhpType)PhpType.MIXED) || argumentType.hasUnknown()) {
                    return;
                }
                for (PhpMatchArm arm : matchExpression.getMatchArms()) {
                    for (PhpExpression condition : arm.getConditions()) {
                        if (PhpStrictTypeCheckingInspection.isTypeCompatible(argumentType, condition.getGlobalType())) continue;
                        holder.registerProblem((PsiElement)condition, PhpBundle.message("inspection.message.condition.is.never.matched", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{PhpDuplicateMatchConditionInspection.getDeleteElementFix((PsiElement)condition, PhpBundle.message("quickfix.remove.unused.condition", new Object[0]))});
                    }
                }
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpUnusedMatchConditionInspection", "buildVisitor"));
    }
}

