/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nullable;

public abstract class PhpToStringImplementationVisitor
extends PhpElementVisitor {
    public void visitPhpEchoStatement(PhpEchoStatement echoStatement) {
        PhpPsiElement[] arguments;
        for (PhpPsiElement argument : arguments = echoStatement.getArguments()) {
            this.checkToStringImplementation((PsiElement)argument);
        }
    }

    public void visitPhpPrint(PhpPrintExpression printExpression) {
        this.checkToStringImplementation((PsiElement)printExpression.getArgument());
    }

    public void visitPhpBinaryExpression(BinaryExpression expression) {
        if (expression.getOperationType() == PhpTokenTypes.opCONCAT) {
            this.checkToStringImplementation(expression.getLeftOperand());
            this.checkToStringImplementation(expression.getRightOperand());
        }
    }

    public void visitPhpUnaryExpression(UnaryExpression expr) {
        if (PhpPsiUtil.isOfType(expr.getOperation(), PhpTokenTypes.opSTRING_CAST)) {
            this.checkToStringImplementation((PsiElement)expr.getValue());
        }
    }

    public void visitPhpFunctionCall(FunctionReference reference) {
        if (!(reference instanceof MethodReference) && "\\strval".equals(reference.getFQN())) {
            this.checkToStringImplementation(reference.getParameter(0));
        }
    }

    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        PsiElement operation = expression.getOperation();
        if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCONCAT_ASGN)) {
            this.checkToStringImplementation((PsiElement)expression.getVariable());
            this.checkToStringImplementation((PsiElement)expression.getValue());
        }
    }

    public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
        for (PsiElement variable : PhpPsiUtil.getChildren((PsiElement)expression, (Condition<? super PsiElement>)Variable.INSTANCEOF)) {
            this.checkImplementation(variable);
        }
    }

    private void checkToStringImplementation(@Nullable PsiElement element) {
        if (!(element instanceof StringLiteralExpression) && element != null) {
            this.checkImplementation(element);
        }
    }

    protected abstract void checkImplementation(@Nullable PsiElement var1);
}

