/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpToStringImplementationVisitor;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpToStringImplementationInspection
extends PhpInspection {
    public boolean STRICT_MODE = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpToStringImplementationInspection.$$$reportNull$$$0(0);
        }
        return new PhpToStringImplementationVisitor(){

            @Override
            protected void checkImplementation(@Nullable PsiElement element) {
                if (element == null) {
                    return;
                }
                Project project = holder.getProject();
                PhpType completedType = new PhpType().add(element).global(project).filterNull();
                if (!PhpToStringImplementationInspection.this.checkType(completedType, PhpIndex.getInstance((Project)project))) {
                    holder.registerProblem(element, PhpBundle.message("inspection.method.to.string.is.not.implemented", completedType), new LocalQuickFix[0]);
                }
            }
        };
    }

    private boolean checkType(@NotNull PhpType phpType, @NotNull PhpIndex index) {
        if (phpType == null) {
            PhpToStringImplementationInspection.$$$reportNull$$$0(1);
        }
        if (index == null) {
            PhpToStringImplementationInspection.$$$reportNull$$$0(2);
        }
        if (phpType.isAmbiguous() || !phpType.isComplete()) {
            return true;
        }
        for (String type : phpType.getTypes()) {
            boolean canBeConverted;
            boolean bl = canBeConverted = PhpType.isUnresolved((String)type) || PhpType.isPrimitiveType((String)type) || PhpToStringImplementationInspection.hasToStringImplementation(index.getAnyByFQN(type));
            if (canBeConverted && !this.STRICT_MODE) {
                return true;
            }
            if (canBeConverted || !this.STRICT_MODE) continue;
            return false;
        }
        return this.STRICT_MODE;
    }

    private static boolean hasToStringImplementation(Collection<PhpClass> classes) {
        if (classes.isEmpty()) {
            return true;
        }
        for (PhpClass clazz : classes) {
            if (clazz.findMethodByName((CharSequence)"__toString") == null && (!clazz.isAbstract() || !PhpToStringImplementationInspection.childWithToStringExists(clazz))) continue;
            return true;
        }
        return false;
    }

    private static boolean childWithToStringExists(PhpClass clazz) {
        return ContainerUtil.exists((Iterable)PhpClassHierarchyUtils.getAllSubclasses((PhpClass)clazz), c -> c.findMethodByName((CharSequence)"__toString") != null);
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpToStringImplementationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox myStrictModeCheckBox;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myStrictModeCheckBox.setSelected(PhpToStringImplementationInspection.this.STRICT_MODE);
            this.myStrictModeCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpToStringImplementationInspection.this.STRICT_MODE = OptionsPanel.this.myStrictModeCheckBox.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myStrictModeCheckBox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.method.to.string.is.not.implemented.strict.mode"));
            jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 6, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

