/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpDuplicateSwitchCaseBodyInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSwitchCaseWithoutDefaultBranchInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpSwitchCaseWithoutDefaultBranchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                PhpCase defaultCase = switchStatement.getDefaultCase();
                if (defaultCase == null && PhpSwitchCaseWithoutDefaultBranchInspection.getAnchor(switchStatement) != null) {
                    LocalQuickFix[] localQuickFixArray;
                    if (isOnTheFly) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = PhpAddDefaultSwitchCaseQuickFix.FIX;
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    holder.registerProblem((PsiElement)switchStatement, PhpBundle.message("inspection.switch.without.default.case", new Object[0]), fixes);
                }
            }
        };
    }

    private static PsiElement getAnchor(PhpSwitch phpSwitch) {
        PhpCase element = (PhpCase)ArrayUtil.getLastElement((Object[])phpSwitch.getCases());
        if (element != null) {
            return element;
        }
        ASTNode openBrace = phpSwitch.getNode().findChildByType(PhpTokenTypes.chLBRACE);
        return openBrace != null ? openBrace.getPsi() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpSwitchCaseWithoutDefaultBranchInspection", "buildVisitor"));
    }

    private static class PhpAddDefaultSwitchCaseQuickFix
    implements LocalQuickFix,
    IntentionAction {
        private static final PhpAddDefaultSwitchCaseQuickFix FIX = new PhpAddDefaultSwitchCaseQuickFix();

        private PhpAddDefaultSwitchCaseQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpAddDefaultSwitchCaseQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("insert.default.branch", new Object[0]);
            if (string == null) {
                PhpAddDefaultSwitchCaseQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                PhpAddDefaultSwitchCaseQuickFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        private static void insertDefaultSwitchCase(Project project, PhpSwitch phpSwitch) {
            if (phpSwitch == null) {
                return;
            }
            PhpCase defaultCase = PhpPsiElementFactory.createPhpPsiFromText(project, PhpCase.class, "switch(a){ default: throw new \\Exception('Unexpected value');}");
            PsiElement anchor = PhpSwitchCaseWithoutDefaultBranchInspection.getAnchor(phpSwitch);
            if (anchor == null) {
                return;
            }
            if (anchor instanceof PhpCase) {
                PsiElement lastStatement;
                GroupStatement caseBeforeBody = PhpDuplicateSwitchCaseBodyInspection.getBody((PhpCase)anchor);
                PsiElement psiElement = lastStatement = caseBeforeBody != null ? (PsiElement)ArrayUtil.getLastElement((Object[])caseBeforeBody.getStatements()) : null;
                if (!(lastStatement instanceof PhpBreak) && !(lastStatement instanceof PhpReturn)) {
                    PhpAddDefaultSwitchCaseQuickFix.addBreakAsLastStatement((PhpCase)anchor, caseBeforeBody, lastStatement);
                }
            }
            phpSwitch.addAfter((PsiElement)defaultCase, anchor);
        }

        private static void addBreakAsLastStatement(@NotNull PhpCase phpCase, @Nullable GroupStatement body, PsiElement lastStatement) {
            if (phpCase == null) {
                PhpAddDefaultSwitchCaseQuickFix.$$$reportNull$$$0(3);
            }
            PhpBreak phpBreak = PhpPsiElementFactory.createFromText(phpCase.getProject(), PhpBreak.class, "switch a{case 1: break;}");
            assert (phpBreak != null);
            if (lastStatement != null) {
                PsiElement parent = phpBreak.getParent();
                assert (parent != null);
                assert (body != null);
                body.addAfter(parent, lastStatement);
            } else {
                Object breakBody = PhpPsiUtil.getParentByCondition((PsiElement)phpBreak, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
                assert (breakBody != null);
                if (body != null) {
                    body.replace(breakBody);
                } else {
                    ASTNode colonNode = phpCase.getNode().findChildByType(PhpTokenTypes.opCOLON);
                    if (colonNode == null) {
                        return;
                    }
                    phpCase.addAfter(breakBody, colonNode.getPsi());
                }
            }
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            PhpSwitch phpSwitch;
            if (project == null) {
                PhpAddDefaultSwitchCaseQuickFix.$$$reportNull$$$0(4);
            }
            if ((phpSwitch = (PhpSwitch)PhpPsiUtil.getParentByCondition(file.findElementAt(editor.getCaretModel().getOffset()), false, (Condition<? super PsiElement>)PhpSwitch.INSTANCEOF)) == null) {
                return;
            }
            PhpAddDefaultSwitchCaseQuickFix.insertDefaultSwitchCase(project, phpSwitch);
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            PhpAddDefaultSwitchCaseQuickFix.runTemplate(project, editor, file);
        }

        private static void runTemplate(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                PhpAddDefaultSwitchCaseQuickFix.$$$reportNull$$$0(5);
            }
            PhpSwitch phpSwitch = (PhpSwitch)PhpPsiUtil.getParentByCondition(file.findElementAt(editor.getCaretModel().getOffset()), false, (Condition<? super PsiElement>)PhpSwitch.INSTANCEOF);
            assert (phpSwitch != null);
            PhpCase defaultCase = phpSwitch.getDefaultCase();
            assert (defaultCase != null);
            GroupStatement body = PhpDuplicateSwitchCaseBodyInspection.getBody(defaultCase);
            assert (body != null);
            PsiElement argumentOfInsertedCase = body.getStatements()[0];
            editor.getCaretModel().moveToOffset(argumentOfInsertedCase.getTextRange().getStartOffset());
            TemplateBuilderImpl builder = new TemplateBuilderImpl(argumentOfInsertedCase);
            builder.replaceElement(argumentOfInsertedCase, (Expression)new ConstantNode(argumentOfInsertedCase.getText()));
            Template template = builder.buildInlineTemplate();
            TemplateManager.getInstance((Project)project).startTemplate(editor, template);
        }

        public boolean startInWriteAction() {
            return true;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpSwitch phpSwitch;
            if (project == null) {
                PhpAddDefaultSwitchCaseQuickFix.$$$reportNull$$$0(6);
            }
            if (descriptor == null) {
                PhpAddDefaultSwitchCaseQuickFix.$$$reportNull$$$0(7);
            }
            if ((phpSwitch = (PhpSwitch)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)PhpSwitch.INSTANCEOF)) == null) {
                return;
            }
            PhpAddDefaultSwitchCaseQuickFix.insertDefaultSwitchCase(project, phpSwitch);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpSwitchCaseWithoutDefaultBranchInspection$PhpAddDefaultSwitchCaseQuickFix";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpCase";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpSwitchCaseWithoutDefaultBranchInspection$PhpAddDefaultSwitchCaseQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addBreakAsLastStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "runTemplate";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

