/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.NameUtilCore;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSuspiciousNameCombinationInspection
extends PhpInspection {
    private final Collection<NameGroup> myNamedGroups = List.of(new NameGroup("needle", "haystack"), new NameGroup("x", "y"), new NameGroup("top", "bottom", "left", "right"), new NameGroup("year", "month", "week", "day", "hour", "minute", "second"));

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpSuspiciousNameCombinationInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                Object[] arguments = reference.getParameters();
                if (!ContainerUtil.exists((Object[])arguments, arg -> arg instanceof PhpNamedElement && !PhpSuspiciousNameCombinationInspection.this.findNameGroup((PsiElement)arg).isEmpty())) {
                    return;
                }
                Collection<Function> resolvedFunctions = PhpAnnotatorVisitor.resolveFunctions((ParameterListOwner)reference);
                for (int i = 0; i < arguments.length; ++i) {
                    PhpNamedElement argument = (PhpNamedElement)ObjectUtils.tryCast((Object)arguments[i], PhpNamedElement.class);
                    if (argument == null) continue;
                    Collection<NameGroup> group = PhpSuspiciousNameCombinationInspection.this.findNameGroup((PsiElement)argument);
                    if (group.isEmpty()) {
                        return;
                    }
                    Collection<Parameter> parameters = PhpSuspiciousNameCombinationInspection.getParameters(resolvedFunctions, (PsiElement[])arguments, i);
                    if (parameters.isEmpty()) {
                        return;
                    }
                    Collection parametersNamedGroups = parameters.stream().flatMap(p -> PhpSuspiciousNameCombinationInspection.this.findNameGroup((PsiElement)p).stream()).collect(Collectors.toList());
                    if (!PhpSuspiciousNameCombinationInspection.allMismatched(group, parametersNamedGroups)) continue;
                    String parameterName = ((Parameter)ContainerUtil.getFirstItem(parameters)).getName();
                    String argumentName = argument.getName();
                    holder.registerProblem((PsiElement)argument, PhpBundle.message("inspection.message.should.probably.not.be.passed.as.parameter", argumentName, parameterName), new LocalQuickFix[0]);
                }
            }

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                PhpPsiElement variable = assignmentExpression.getVariable();
                PhpPsiElement value = assignmentExpression.getValue();
                if (variable == null || value == null || variable instanceof Variable && value instanceof Variable) {
                    return;
                }
                Collection<NameGroup> variableGroup = PhpSuspiciousNameCombinationInspection.this.findNameGroup((PsiElement)variable);
                Collection<NameGroup> valueGroup = PhpSuspiciousNameCombinationInspection.this.findNameGroup((PsiElement)value);
                if (PhpSuspiciousNameCombinationInspection.allMismatched(valueGroup, variableGroup)) {
                    holder.registerProblem((PsiElement)variable, PhpBundle.message("inspection.message.should.probably.not.be.assigned", variable.getText(), value.getText()), new LocalQuickFix[0]);
                }
            }
        };
    }

    private static boolean allMismatched(Collection<NameGroup> group, Collection<NameGroup> group1) {
        if (group.isEmpty() || group1.isEmpty()) {
            return false;
        }
        for (NameGroup f : group) {
            for (NameGroup s : group1) {
                if (f.isMismatched(s)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private Collection<NameGroup> findNameGroup(@Nullable PsiElement p) {
        String name;
        String string = p instanceof PhpNamedElement ? ((PhpNamedElement)p).getName() : (name = p instanceof PhpReference ? ((PhpReference)p).getName() : null);
        if (name == null) {
            List<NameGroup> list = Collections.emptyList();
            if (list == null) {
                PhpSuspiciousNameCombinationInspection.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = StreamEx.of((Object[])NameUtilCore.splitNameIntoWords((String)name)).map(word -> StringUtil.toLowerCase((String)word.trim())).flatMap(word -> this.myNamedGroups.stream().map(group -> group.forWord((String)word))).nonNull().toList();
        if (list == null) {
            PhpSuspiciousNameCombinationInspection.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private static Collection<Parameter> getParameters(Collection<Function> resolvedFunctions, PsiElement[] arguments, int i) {
        List list = ContainerUtil.map(resolvedFunctions, f -> PhpParamsInspection.getMappedParam(Arrays.asList(arguments), Arrays.asList(f.getParameters()), i));
        if (list == null) {
            PhpSuspiciousNameCombinationInspection.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpSuspiciousNameCombinationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpSuspiciousNameCombinationInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findNameGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NameGroup {
        private final List<String> myWords;
        private int myIndex;

        private NameGroup(String ... words) {
            this.myWords = Arrays.asList(words);
        }

        private NameGroup(int index, List<String> words) {
            this.myIndex = index;
            this.myWords = words;
        }

        @Nullable
        public NameGroup forWord(String word) {
            int index = this.myWords.indexOf(word);
            return index >= 0 ? new NameGroup(index, this.myWords) : null;
        }

        public boolean isMismatched(NameGroup group) {
            return group.myIndex != this.myIndex && this.myWords.equals(group.myWords);
        }
    }
}

