/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.elements.impl.GroupStatementImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpStatementHasEmptyBodyInspection
extends PhpInspection {
    public boolean myCommentsCountAsContent = false;
    public boolean myIgnoreWhileWithoutBody = false;
    public boolean myIgnoreForWithoutBody = false;
    @Nls
    public static final String DELETE_ELEMENT_FIX_NAME = PhpBundle.message("delete.unused.element", new Object[0]);
    @Nls
    public static final String EXTRACT_SIDE_EFFECT_FIX_NAME = PhpBundle.message("extract.side.effect", new Object[0]);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpIf(If ifStatement) {
                boolean emptyElseBranch;
                Else elseBranch = ifStatement.getElseBranch();
                boolean bl = emptyElseBranch = elseBranch == null || PhpStatementHasEmptyBodyInspection.this.isEmpty((PsiElement)elseBranch.getStatement());
                if (PhpStatementHasEmptyBodyInspection.this.isEmpty((PsiElement)ifStatement.getStatement())) {
                    LocalQuickFix[] fixes = emptyElseBranch && ifStatement.getElseIfBranches().length == 0 ? PhpStatementHasEmptyBodyInspection.createFixes((StatementWithArgument)ifStatement) : LocalQuickFix.EMPTY_ARRAY;
                    PhpStatementHasEmptyBodyInspection.registerProblem((PsiElement)ifStatement, holder, fixes);
                    if (fixes.length > 0) {
                        return;
                    }
                }
                if (elseBranch != null && emptyElseBranch) {
                    PhpStatementHasEmptyBodyInspection.registerProblem((PsiElement)elseBranch, holder, new LocalQuickFix[]{new PhpDeleteElementQuickFix((PsiElement)elseBranch, DELETE_ELEMENT_FIX_NAME)});
                }
            }

            public void visitPhpElseIf(ElseIf elseIfStatement) {
                LocalQuickFix[] fixes = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)elseIfStatement, true) == null ? PhpStatementHasEmptyBodyInspection.createFixes((StatementWithArgument)elseIfStatement) : LocalQuickFix.EMPTY_ARRAY;
                this.processStatement((PsiElement)elseIfStatement, (PsiElement)elseIfStatement.getStatement(), fixes);
            }

            public void visitPhpForeach(ForeachStatement foreach) {
                this.processStatement((PsiElement)foreach, (PsiElement)foreach.getStatement(), new LocalQuickFix[0]);
            }

            public void visitPhpFor(For forStatement) {
                Statement statement = forStatement.getStatement();
                if (PhpStatementHasEmptyBodyInspection.this.myIgnoreForWithoutBody && statement != null && PhpPsiUtil.isOfType(statement.getFirstChild(), PhpTokenTypes.opSEMICOLON)) {
                    return;
                }
                this.processStatement((PsiElement)forStatement, (PsiElement)statement, new LocalQuickFix[0]);
            }

            public void visitPhpWhile(While whileStatement) {
                Statement statement = whileStatement.getStatement();
                if (PhpStatementHasEmptyBodyInspection.this.myIgnoreWhileWithoutBody && statement != null && PhpPsiUtil.isOfType(statement.getFirstChild(), PhpTokenTypes.opSEMICOLON)) {
                    return;
                }
                this.processStatement((PsiElement)whileStatement, (PsiElement)statement, new LocalQuickFix[0]);
            }

            public void visitPhpDoWhile(DoWhile doWhileStatement) {
                this.processStatement((PsiElement)doWhileStatement, (PsiElement)doWhileStatement.getStatement(), new LocalQuickFix[0]);
            }

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                this.processStatement((PsiElement)switchStatement, (PsiElement)switchStatement, PhpStatementHasEmptyBodyInspection.createFixes((StatementWithArgument)switchStatement));
            }

            public void visitPhpTry(Try tryStatement2) {
                this.processStatement((PsiElement)tryStatement2, (PsiElement)tryStatement2.getStatement(), new LocalQuickFix[]{new PhpDeleteElementUnderControlStatementQuickFix((PsiElement)tryStatement2)});
            }

            public void visitPhpFinally(Finally element) {
                this.processStatement((PsiElement)element, (PsiElement)element.getStatement(), new LocalQuickFix[]{new PhpDeleteElementUnderControlStatementQuickFix((PsiElement)element)});
            }

            private void processStatement(@NotNull PsiElement parent, @Nullable PsiElement statement, LocalQuickFix ... fixes) {
                if (parent == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PhpStatementHasEmptyBodyInspection.this.isEmpty(statement)) {
                    PhpStatementHasEmptyBodyInspection.registerProblem(parent, holder, fixes);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$1", "processStatement"));
            }
        };
    }

    private static LocalQuickFix @NotNull [] createFixes(StatementWithArgument statement) {
        LocalQuickFixOnPsiElement deleteElementFix;
        LocalQuickFixOnPsiElement localQuickFixOnPsiElement = deleteElementFix = statement instanceof ElseIf ? new PhpDeleteElementQuickFix((PsiElement)statement, DELETE_ELEMENT_FIX_NAME) : new PhpDeleteElementUnderControlStatementQuickFix((PsiElement)statement);
        if (!PhpSideEffectDetector.canContainSideEffect(statement.getArgument())) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{deleteElementFix};
            if (localQuickFixArray == null) {
                PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(1);
            }
            return localQuickFixArray;
        }
        LocalQuickFixOnPsiElement extractSideEffectFix = statement instanceof ElseIf ? new PhpExtractSideEffectFromElseIfQuickFix(statement) : new PhpExtractSideEffectQuickFix(statement);
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{extractSideEffectFix, deleteElementFix};
        if (localQuickFixArray == null) {
            PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(2);
        }
        return localQuickFixArray;
    }

    private static void registerProblem(@NotNull PsiElement parent, @NotNull ProblemsHolder holder, LocalQuickFix ... fixes) {
        PsiElement firstChild;
        if (parent == null) {
            PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(4);
        }
        if ((firstChild = parent.getFirstChild()) != null) {
            holder.registerProblem(firstChild, PhpBundle.message("inspection.php.statement.has.empty.body.description", new Object[0]), fixes);
        }
    }

    @Contract(value="null -> false")
    private boolean isEmpty(@Nullable PsiElement element) {
        if (element instanceof PhpSwitch) {
            return ((PhpSwitch)element).getAllCases().length == 0;
        }
        if (element instanceof PsiWhiteSpace) {
            return true;
        }
        if (element instanceof PsiComment) {
            return !this.myCommentsCountAsContent;
        }
        if (element instanceof Statement) {
            PsiElement firstChild = element.getFirstChild();
            if (PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.opSEMICOLON)) {
                return !this.myCommentsCountAsContent || !(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(element, true) instanceof PsiComment);
            }
            if (element instanceof GroupStatement) {
                return this.isEmpty((GroupStatement)element);
            }
        }
        return false;
    }

    private boolean isEmpty(@NotNull GroupStatement statement) {
        if (statement == null) {
            PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(5);
        }
        for (PsiElement s = statement.getFirstChild(); s != null; s = s.getNextSibling()) {
            if (PhpPsiUtil.isOfType(s, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE) || this.isEmpty(s)) continue;
            return false;
        }
        return !this.myCommentsCountAsContent || !(PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)statement, true) instanceof PsiComment) && !(PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)statement, true) instanceof PsiComment);
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(PhpBundle.message("inspection.statement.has.empty.body.comments.count.as.content", new Object[0]), "myCommentsCountAsContent");
        optionsPanel.addCheckbox(PhpBundle.message("inspection.statement.has.empty.body.ignore.empty.while", new Object[0]), "myIgnoreWhileWithoutBody");
        optionsPanel.addCheckbox(PhpBundle.message("inspection.statement.has.empty.body.ignore.empty.for", new Object[0]), "myIgnoreForWithoutBody");
        return optionsPanel;
    }

    @Nullable
    private static Statement getInnerStatement(@NotNull PsiElement startElement) {
        if (startElement == null) {
            PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(6);
        }
        return startElement instanceof ControlStatement ? ((ControlStatement)startElement).getStatement() : (Statement)PhpPsiUtil.getChildByCondition(startElement, (Condition<? super PsiElement>)Statement.INSTANCEOF);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInnerStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PhpExtractSideEffectFromElseIfQuickFix
    extends LocalQuickFixOnPsiElement {
        private PhpExtractSideEffectFromElseIfQuickFix(StatementWithArgument statement) {
            super((PsiElement)statement);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiElement argument;
            if (project == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(4);
            }
            if ((argument = ((StatementWithArgument)startElement).getArgument()) != null) {
                GroupStatement elseIfStatement = PhpExtractSideEffectFromElseIfQuickFix.createStatement(project, (ElseIf)startElement);
                elseIfStatement.addAfter((PsiElement)PhpExtractSideEffectQuickFix.createStatement(project, argument), elseIfStatement.getFirstChild());
                startElement.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, Else.class, "if () {} else " + elseIfStatement.getText()));
            }
        }

        @NotNull
        private static GroupStatement createStatement(@NotNull Project project, @NotNull ElseIf startElement) {
            GroupStatement statement;
            if (project == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(5);
            }
            if (startElement == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(6);
            }
            if ((statement = (GroupStatement)ObjectUtils.tryCast((Object)startElement.getStatement(), GroupStatement.class)) != null && PhpPsiUtil.isOfType(statement.getFirstChild(), PhpTokenTypes.chLBRACE)) {
                GroupStatement groupStatement = (GroupStatement)statement.copy();
                if (groupStatement == null) {
                    PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(7);
                }
                return groupStatement;
            }
            String statementText = statement != null ? "{" + statement.getText() + "}" : "{}";
            GroupStatement groupStatement = PhpPsiElementFactory.createPhpPsiFromText(project, GroupStatementImpl.class, "if " + statementText);
            if (groupStatement == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(8);
            }
            return groupStatement;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = EXTRACT_SIDE_EFFECT_FIX_NAME;
            if (string == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$PhpExtractSideEffectFromElseIfQuickFix";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$PhpExtractSideEffectFromElseIfQuickFix";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStatement";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createStatement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PhpExtractSideEffectQuickFix
    extends LocalQuickFixOnPsiElement {
        private PhpExtractSideEffectQuickFix(StatementWithArgument statement) {
            super((PsiElement)statement);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpExtractSideEffectQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiElement argument;
            if (project == null) {
                PhpExtractSideEffectQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                PhpExtractSideEffectQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                PhpExtractSideEffectQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                PhpExtractSideEffectQuickFix.$$$reportNull$$$0(4);
            }
            if ((argument = ((StatementWithArgument)startElement).getArgument()) != null) {
                startElement.replace((PsiElement)PhpExtractSideEffectQuickFix.createStatement(project, argument));
            }
        }

        @NotNull
        private static Statement createStatement(@NotNull Project project, PsiElement argument) {
            if (project == null) {
                PhpExtractSideEffectQuickFix.$$$reportNull$$$0(5);
            }
            Statement statement = PhpPsiElementFactory.createStatement(project, argument.getText() + ";");
            if (statement == null) {
                PhpExtractSideEffectQuickFix.$$$reportNull$$$0(6);
            }
            return statement;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = EXTRACT_SIDE_EFFECT_FIX_NAME;
            if (string == null) {
                PhpExtractSideEffectQuickFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$PhpExtractSideEffectQuickFix";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$PhpExtractSideEffectQuickFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStatement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createStatement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PhpDeleteElementUnderControlStatementQuickFix
    extends LocalQuickFixOnPsiElement {
        private PhpDeleteElementUnderControlStatementQuickFix(PsiElement element) {
            super(element);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Statement innerStatement;
            PsiElement parent;
            if (project == null) {
                PhpDeleteElementUnderControlStatementQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpDeleteElementUnderControlStatementQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpDeleteElementUnderControlStatementQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpDeleteElementUnderControlStatementQuickFix.$$$reportNull$$$0(3);
            }
            if (((parent = startElement.getParent()) instanceof ControlStatement || parent instanceof Else) && (innerStatement = PhpStatementHasEmptyBodyInspection.getInnerStatement(startElement)) != null) {
                startElement.replace((PsiElement)innerStatement);
                return;
            }
            startElement.delete();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = DELETE_ELEMENT_FIX_NAME;
            if (string == null) {
                PhpDeleteElementUnderControlStatementQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpDeleteElementUnderControlStatementQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$PhpDeleteElementUnderControlStatementQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$PhpDeleteElementUnderControlStatementQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

