/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.probablyBug.PhpDuplicateEntitiesInspectionBase;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDuplicateSwitchCaseBodyInspection
extends PhpDuplicateEntitiesInspectionBase<PhpSwitch, PhpCase> {
    @Nls
    public static final String DELETE_REDUNDANT_SWITCH_BRANCH_FIX_NAME = PhpBundle.message("delete.redundant.switch.branch", new Object[0]);
    private static final int SWITCH_CASES_TO_CONSIDER = 200;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDuplicateSwitchCaseBodyInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                PhpDuplicateSwitchCaseBodyInspection.this.processDuplicateEntries(switchStatement, holder);
            }
        };
    }

    @Override
    @NotNull
    protected List<PhpCase> getElements(@NotNull PhpSwitch switchStatement) {
        if (switchStatement == null) {
            PhpDuplicateSwitchCaseBodyInspection.$$$reportNull$$$0(1);
        }
        List<PhpCase> allCases = Arrays.asList(PhpDuplicateSwitchCaseBodyInspection.getCasesFromTailToConsider(switchStatement.getAllCases()));
        PhpCase defaultCase = switchStatement.getDefaultCase();
        if (defaultCase != null) {
            PhpDuplicateSwitchCaseBodyInspection.moveDefaultCaseOnFirstPlace(allCases, defaultCase);
        }
        List<PhpCase> list = allCases;
        if (list == null) {
            PhpDuplicateSwitchCaseBodyInspection.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static void moveDefaultCaseOnFirstPlace(List<PhpCase> allCases, @NotNull PhpCase defaultCase) {
        if (defaultCase == null) {
            PhpDuplicateSwitchCaseBodyInspection.$$$reportNull$$$0(3);
        }
        int defaultCaseIndex = ContainerUtil.indexOf(allCases, c -> c == defaultCase);
        while (defaultCaseIndex > 0) {
            ContainerUtil.swapElements(allCases, (int)defaultCaseIndex--, (int)defaultCaseIndex);
        }
    }

    private static PhpCase[] getCasesFromTailToConsider(PhpCase[] cases) {
        return cases.length <= 200 ? cases : Arrays.copyOfRange(cases, cases.length - 200, cases.length);
    }

    @Override
    protected void registerDuplicatedEntry(@NotNull ProblemsHolder holder, PhpCase duplicatedEntry, PhpCase originalEntry) {
        if (holder == null) {
            PhpDuplicateSwitchCaseBodyInspection.$$$reportNull$$$0(4);
        }
        PhpSwitch switchStatement = (PhpSwitch)originalEntry.getParent();
        ArrayList<Object> fixes = new ArrayList<Object>();
        PhpMergeSwitchCasesQuickFix fix = new PhpMergeSwitchCasesQuickFix(originalEntry, switchStatement);
        fixes.add(fix);
        if (originalEntry == switchStatement.getDefaultCase()) {
            fixes.add(PhpDeleteRedundantSwitchCaseQuickFix.INSTANCE);
        }
        holder.registerProblem((PsiElement)duplicatedEntry, PhpBundle.message("inspection.duplicate.switch.case.body", PhpDuplicateSwitchCaseBodyInspection.getSwitchCaseName(originalEntry, switchStatement)), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    @NotNull
    private static String getSwitchCaseName(PhpCase aCase, PhpSwitch switchStatement) {
        if (switchStatement.getDefaultCase() == aCase) {
            return "default";
        }
        PhpPsiElement condition = aCase.getCondition();
        String string = "case " + (condition != null ? condition.getText() : "");
        if (string == null) {
            PhpDuplicateSwitchCaseBodyInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean explicitlyBreaks(@Nullable PsiElement caseBody) {
        return PsiTreeUtil.findChildOfAnyType((PsiElement)caseBody, (Class[])new Class[]{PhpBreak.class, PhpReturn.class}) != null;
    }

    @Override
    protected PsiElement getElementToCheckDuplication(@NotNull PhpCase element) {
        if (element == null) {
            PhpDuplicateSwitchCaseBodyInspection.$$$reportNull$$$0(6);
        }
        return PhpDuplicateSwitchCaseBodyInspection.getBody(element);
    }

    @Override
    protected boolean isApplicable(@NotNull PsiElement elementToCheck) {
        if (elementToCheck == null) {
            PhpDuplicateSwitchCaseBodyInspection.$$$reportNull$$$0(7);
        }
        return PhpDuplicateSwitchCaseBodyInspection.explicitlyBreaks(elementToCheck);
    }

    @Nullable
    public static GroupStatement getBody(@Nullable PhpCase aCase) {
        GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)aCase, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (groupStatement == null) {
            return null;
        }
        return groupStatement.statements().isNotEmpty() ? groupStatement : null;
    }

    private static void deleteCase(PhpCase phpCase) {
        GroupStatement prevBody;
        if (phpCase == null) {
            return;
        }
        PhpCase prevCase = (PhpCase)ObjectUtils.tryCast((Object)PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)phpCase, true), PhpCase.class);
        if (prevCase != null && ((prevBody = PhpDuplicateSwitchCaseBodyInspection.getBody(prevCase)) == null || prevBody.statements().isEmpty())) {
            PhpDuplicateSwitchCaseBodyInspection.replaceCondition(phpCase, prevCase.getCondition());
            prevCase.delete();
            return;
        }
        phpCase.delete();
    }

    private static void replaceCondition(@NotNull PhpCase phpCase, PhpPsiElement condition) {
        if (phpCase == null) {
            PhpDuplicateSwitchCaseBodyInspection.$$$reportNull$$$0(8);
        }
        if (condition == null) {
            return;
        }
        PhpPsiElement myCondition = phpCase.getCondition();
        if (myCondition == null) {
            return;
        }
        myCondition.replace(condition.copy());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicateSwitchCaseBodyInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicateSwitchCaseBodyInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwitchCaseName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveDefaultCaseOnFirstPlace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerDuplicatedEntry";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementToCheckDuplication";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceCondition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PhpMergeSwitchCasesQuickFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PhpCase> myCaseToMerge;
        private final String myCaseToMergeName;

        private PhpMergeSwitchCasesQuickFix(PhpCase caseToMerge, PhpSwitch switchStatement) {
            this.myCaseToMerge = SmartPointerManager.getInstance((Project)caseToMerge.getProject()).createSmartPsiElementPointer((PsiElement)caseToMerge);
            this.myCaseToMergeName = PhpDuplicateSwitchCaseBodyInspection.getSwitchCaseName(caseToMerge, switchStatement);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("merge.with.0.branch", this.myCaseToMergeName);
            if (string == null) {
                PhpMergeSwitchCasesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpCase caseToMerge;
            if (project == null) {
                PhpMergeSwitchCasesQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpMergeSwitchCasesQuickFix.$$$reportNull$$$0(2);
            }
            if ((caseToMerge = (PhpCase)this.myCaseToMerge.getElement()) == null) {
                return;
            }
            PhpCase currentCase = (PhpCase)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)PhpCase.INSTANCEOF);
            if (currentCase == null) {
                return;
            }
            PhpCase currentCaseCopy = PhpMergeSwitchCasesQuickFix.createEmptyCaseWithCopiedCondition(project, currentCase);
            if (currentCaseCopy == null) {
                return;
            }
            caseToMerge.getParent().addBefore((PsiElement)currentCaseCopy, (PsiElement)caseToMerge);
            PhpDuplicateSwitchCaseBodyInspection.deleteCase(currentCase);
        }

        @Nullable
        private static PhpCase createEmptyCaseWithCopiedCondition(@NotNull Project project, PhpCase currentCase) {
            PhpPsiElement condition;
            if (project == null) {
                PhpMergeSwitchCasesQuickFix.$$$reportNull$$$0(3);
            }
            if ((condition = currentCase.getCondition()) == null) {
                return null;
            }
            return PhpPsiElementFactory.createPhpPsiFromText(project, PhpCase.class, String.format("switch ($a) { case %s: }", condition.getText()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicateSwitchCaseBodyInspection$PhpMergeSwitchCasesQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicateSwitchCaseBodyInspection$PhpMergeSwitchCasesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createEmptyCaseWithCopiedCondition";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpDeleteRedundantSwitchCaseQuickFix
    implements LocalQuickFix {
        static final PhpDeleteRedundantSwitchCaseQuickFix INSTANCE = new PhpDeleteRedundantSwitchCaseQuickFix();

        private PhpDeleteRedundantSwitchCaseQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = DELETE_REDUNDANT_SWITCH_BRANCH_FIX_NAME;
            if (string == null) {
                PhpDeleteRedundantSwitchCaseQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpDeleteRedundantSwitchCaseQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpDeleteRedundantSwitchCaseQuickFix.$$$reportNull$$$0(2);
            }
            PhpCase phpCase = (PhpCase)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)PhpCase.INSTANCEOF);
            PhpDuplicateSwitchCaseBodyInspection.deleteCase(phpCase);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicateSwitchCaseBodyInspection$PhpDeleteRedundantSwitchCaseQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicateSwitchCaseBodyInspection$PhpDeleteRedundantSwitchCaseQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

