/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit.quickfix;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitDeprecatedExpectExceptionInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveStatementQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix
extends PhpQuickFixBase {
    private final String myNewMethodName;

    public PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix(@NotNull String newMethodName) {
        if (newMethodName == null) {
            PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix.$$$reportNull$$$0(0);
        }
        this.myNewMethodName = newMethodName;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.phpunit.replace.current.method.with.alternative", this.myNewMethodName);
        if (string == null) {
            PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix.$$$reportNull$$$0(3);
        }
        PsiElement methodIdentifier = descriptor.getPsiElement();
        MethodReference reference = (MethodReference)PhpPsiUtil.getParentByCondition(methodIdentifier, (Condition<? super PsiElement>)((Condition)MethodReference.class::isInstance));
        if (reference == null) {
            return;
        }
        ParameterList parametersList = reference.getParameterList();
        if (parametersList == null) {
            return;
        }
        String removedParameterFqn = PhpUnitDeprecatedExpectExceptionInspection.getClassFqnOfDeprecatedParameter(reference);
        if (removedParameterFqn == null) {
            return;
        }
        methodIdentifier.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.IDENTIFIER, this.myNewMethodName));
        parametersList.replace((PsiElement)PhpPsiElementFactory.createParameterList(project, ""));
        PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix.removeUnusedStatements(descriptor, removedParameterFqn);
    }

    private static void removeUnusedStatements(@NotNull ProblemDescriptor descriptor, @NotNull String removedParameterFqn) {
        PhpPsiElement scope;
        if (descriptor == null) {
            PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix.$$$reportNull$$$0(4);
        }
        if (removedParameterFqn == null) {
            PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix.$$$reportNull$$$0(5);
        }
        if ((scope = PhpCodeInsightUtil.findScopeForUseOperator(descriptor.getPsiElement())) == null) {
            return;
        }
        PhpCodeInsightUtil.collectImports(scope).stream().flatMap(useList -> Arrays.stream(useList.getDeclarations())).filter(use -> PhpCodeInsightUtil.isUnused(use)).filter(use -> use.getTargetReference() != null && removedParameterFqn.equalsIgnoreCase(use.getTargetReference().getFQN())).forEach(use -> PhpRemoveStatementQuickFix.REMOVE_USE.remove((PsiElement)use));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMethodName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/quickfix/PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedParameterFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/quickfix/PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeUnusedStatements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

