/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit.quickfix;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.classes.PhpNamedArgumentsWithChangedOrderInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitReplaceAssertMethodReferenceQuickFix
extends PhpQuickFixBase {
    private final String myNewMethodName;
    private final int myParametersNumberToReplace;

    public PhpUnitReplaceAssertMethodReferenceQuickFix(@NotNull String newMethodName, int parametersNumberToReplace) {
        if (newMethodName == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(0);
        }
        this.myNewMethodName = newMethodName;
        this.myParametersNumberToReplace = parametersNumberToReplace;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.phpunit.replace.current.method.with.alternative", this.myNewMethodName);
        if (string == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement methodIdentifier;
        if (project == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(3);
        }
        if ((methodIdentifier = this.getMethodIdentifierFromProblemDescriptor(descriptor)) == null) {
            return;
        }
        ParameterList parameterList = (ParameterList)PhpPsiUtil.getNextSiblingByCondition(methodIdentifier, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
        if (parameterList == null) {
            return;
        }
        PhpNamedArgumentsWithChangedOrderInspection.sortNamedArguments(project, parameterList);
        PhpUnitReplaceAssertMethodReferenceQuickFix.dropNameIdentifiers(parameterList);
        methodIdentifier.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.IDENTIFIER, this.myNewMethodName));
        String newParametersListText = this.getNewParameterListText(parameterList);
        if (newParametersListText != null) {
            parameterList.replace((PsiElement)PhpPsiElementFactory.createArgumentList(project, newParametersListText));
        }
    }

    protected static void dropNameIdentifiers(ParameterList parameterList) {
        ArrayList<PsiElement> elementsToDelete = new ArrayList<PsiElement>();
        for (PsiElement child = parameterList.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!PhpPsiUtil.isOfType(child, PhpTokenTypes.IDENTIFIER, PhpTokenTypes.opCOLON)) continue;
            elementsToDelete.add(child);
        }
        elementsToDelete.forEach(PsiElement::delete);
    }

    @Nullable
    protected PsiElement getMethodIdentifierFromProblemDescriptor(@NotNull ProblemDescriptor descriptor) {
        PsiElement descriptorPsiElement;
        if (descriptor == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(4);
        }
        if (!PhpPsiUtil.isOfType(descriptorPsiElement = descriptor.getPsiElement(), PhpTokenTypes.IDENTIFIER)) {
            return null;
        }
        return descriptorPsiElement;
    }

    @Nullable
    private String getNewParameterListText(@NotNull ParameterList parameterList) {
        PsiElement[] parameterArray;
        PsiElement[] newParameterArray;
        if (parameterList == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(5);
        }
        if ((newParameterArray = this.createNewParameters(parameterArray = parameterList.getParameters())) == null) {
            return null;
        }
        if (newParameterArray.length == 0) {
            return "";
        }
        String fileContent = parameterList.getContainingFile().getText();
        StringBuilder formattedParameterListString = new StringBuilder();
        formattedParameterListString.append(newParameterArray[0].getText());
        for (int i = 1; i < newParameterArray.length; ++i) {
            PsiElement currentParameter = newParameterArray[i];
            String textBeforeCurrentParameter = fileContent.substring(parameterArray[i - 1].getTextRange().getEndOffset(), parameterArray[i].getTextRange().getStartOffset());
            formattedParameterListString.append(textBeforeCurrentParameter);
            formattedParameterListString.append(currentParameter.getText());
        }
        return formattedParameterListString.toString();
    }

    protected PsiElement @Nullable [] createNewParameters(PsiElement @NotNull [] parameters) {
        if (parameters == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(6);
        }
        if (this.myParametersNumberToReplace <= parameters.length) {
            return Arrays.copyOf(parameters, this.myParametersNumberToReplace);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMethodName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/quickfix/PhpUnitReplaceAssertMethodReferenceQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/quickfix/PhpUnitReplaceAssertMethodReferenceQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMethodIdentifierFromProblemDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNewParameterListText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNewParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

