/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpunit.AssertType;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertArrayHasKeyInspection;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitMisorderedAssertEqualsArgumentsInspection
extends PhpInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpUnitFlipArgumentsQuickFix.INSTANCE};
    private static final IElementType[] EXPECTED_PARAMETER_TYPES = new IElementType[]{PhpElementTypes.STRING, PhpElementTypes.NUMBER, PhpElementTypes.CONSTANT_REF, PhpElementTypes.CLASS_CONSTANT_REFERENCE};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnitMisorderedAssertEqualsArgumentsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethodReference(MethodReference reference) {
                AssertType assertType = AssertType.getAssertType(reference);
                if (!(assertType != null && AssertType.EQUALS_TYPES.contains((Object)assertType) && PhpUnitAssertUtil.isInsideTestClass((PsiElement)reference) && PhpUnitAssertUtil.isImplementedInPhpUnitAssertClass(reference))) {
                    return;
                }
                PsiElement first = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(reference, 0);
                PsiElement second = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(reference, 1);
                if (first == null || second == null || PhpUnitMisorderedAssertEqualsArgumentsInspection.looksLikeExpectedArgument(first) || !PhpUnitMisorderedAssertEqualsArgumentsInspection.looksLikeExpectedArgument(second)) {
                    return;
                }
                PsiElement methodIdentifier = PhpPsiUtil.getChildOfType((PsiElement)reference, PhpTokenTypes.IDENTIFIER);
                if (methodIdentifier != null) {
                    holder.registerProblem(methodIdentifier, PhpBundle.message("inspection.phpunit.asserts.assertEquals.misordered.arguments", new Object[]{assertType}), FIXES);
                }
            }
        };
    }

    private static boolean looksLikeExpectedArgument(@NotNull PsiElement parameter) {
        if (parameter == null) {
            PhpUnitMisorderedAssertEqualsArgumentsInspection.$$$reportNull$$$0(1);
        }
        if (PhpPsiUtil.isOfType(parameter, PhpElementTypes.ARRAY_CREATION_EXPRESSION)) {
            return PhpUnitMisorderedAssertEqualsArgumentsInspection.isExpectedValueArrayElements(parameter);
        }
        if (PhpPsiUtil.isOfType(parameter, PhpElementTypes.INFIX_EXPRESSION)) {
            PsiElement unaryExpressionValue = PhpUnitMisorderedAssertEqualsArgumentsInspection.getUnaryExpressionValue(parameter);
            return unaryExpressionValue != null && PhpUnitMisorderedAssertEqualsArgumentsInspection.looksLikeExpectedArgument(unaryExpressionValue);
        }
        return PhpPsiUtil.isOfType(parameter, EXPECTED_PARAMETER_TYPES);
    }

    private static boolean isExpectedValueArrayElements(@NotNull PsiElement parameter) {
        ArrayCreationExpression arrayCreationExpression;
        if (parameter == null) {
            PhpUnitMisorderedAssertEqualsArgumentsInspection.$$$reportNull$$$0(2);
        }
        if ((arrayCreationExpression = (ArrayCreationExpression)ObjectUtils.tryCast((Object)parameter, ArrayCreationExpression.class)) == null) {
            return false;
        }
        for (PhpPsiElement element : ArrayCreationExpressionImpl.children(arrayCreationExpression)) {
            PhpPsiElement innerArrayElement = element instanceof ArrayHashElement ? ((ArrayHashElement)element).getValue() : element.getFirstPsiChild();
            if (innerArrayElement != null && PhpUnitMisorderedAssertEqualsArgumentsInspection.looksLikeExpectedArgument((PsiElement)innerArrayElement)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static PsiElement getUnaryExpressionValue(@NotNull PsiElement parameter) {
        UnaryExpression unaryExpression;
        if (parameter == null) {
            PhpUnitMisorderedAssertEqualsArgumentsInspection.$$$reportNull$$$0(3);
        }
        if ((unaryExpression = (UnaryExpression)ObjectUtils.tryCast((Object)parameter, UnaryExpression.class)) == null) {
            return null;
        }
        return unaryExpression.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitMisorderedAssertEqualsArgumentsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "looksLikeExpectedArgument";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isExpectedValueArrayElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnaryExpressionValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpUnitFlipArgumentsQuickFix
    extends PhpQuickFixBase {
        private static final PhpUnitFlipArgumentsQuickFix INSTANCE = new PhpUnitFlipArgumentsQuickFix();

        private PhpUnitFlipArgumentsQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.phpunit.assert.equals.flip.compared.arguments", new Object[0]);
            if (string == null) {
                PhpUnitFlipArgumentsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement methodIdentifier;
            if (project == null) {
                PhpUnitFlipArgumentsQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpUnitFlipArgumentsQuickFix.$$$reportNull$$$0(2);
            }
            if (!PhpPsiUtil.isOfType(methodIdentifier = descriptor.getPsiElement(), PhpTokenTypes.IDENTIFIER)) {
                return;
            }
            MethodReference reference = (MethodReference)PhpPsiUtil.getParentByCondition(methodIdentifier, (Condition<? super PsiElement>)((Condition)MethodReference.class::isInstance));
            if (reference == null) {
                return;
            }
            PsiElement first = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(reference, 0);
            PsiElement second = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(reference, 1);
            if (first == null || second == null) {
                return;
            }
            PsiElement tmp = first.copy();
            first.replace(second);
            second.replace(tmp);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitMisorderedAssertEqualsArgumentsInspection$PhpUnitFlipArgumentsQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitMisorderedAssertEqualsArgumentsInspection$PhpUnitFlipArgumentsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

