/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import org.jetbrains.annotations.NotNull;

public final class PhpUnitAssertUtil {
    private static final String PHPUNIT_ASSERT_FQN = "\\PHPUnit_Framework_Assert";
    private static final String PHPUNIT6_ASSERT_FQN = "\\PHPUnit\\Framework\\Assert";

    private PhpUnitAssertUtil() {
    }

    public static boolean isInsideTestClass(@NotNull PsiElement psiElement) {
        PhpClass currentClass;
        if (psiElement == null) {
            PhpUnitAssertUtil.$$$reportNull$$$0(0);
        }
        return (currentClass = (PhpClass)PhpPsiUtil.getParentByCondition(psiElement, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null && PhpUnitUtil.isTestClass(currentClass);
    }

    public static boolean isImplementedInPhpUnitAssertClass(@NotNull MethodReference methodReference) {
        PhpClass methodImplementationClass;
        if (methodReference == null) {
            PhpUnitAssertUtil.$$$reportNull$$$0(1);
        }
        if ((methodImplementationClass = (PhpClass)PhpPsiUtil.getParentByCondition(methodReference.resolve(), (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) == null) {
            return false;
        }
        return StringUtil.equalsIgnoreCase((CharSequence)PHPUNIT_ASSERT_FQN, (CharSequence)methodImplementationClass.getFQN()) || StringUtil.equalsIgnoreCase((CharSequence)PHPUNIT6_ASSERT_FQN, (CharSequence)methodImplementationClass.getFQN());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideTestClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplementedInPhpUnitAssertClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

