/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.phpunit.AssertType;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertArrayHasKeyInspection;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertInspectionBase;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.AssertParameter;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitDropOptionalParametersQuickFix;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitReplaceAssertMethodReferenceQuickFix;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitAssertContainsInspection
extends PhpUnitAssertInspectionBase {
    private static final Set<String> SPECIALIZED_ASSERT_METHOD_NAMES = ContainerUtil.set((Object[])new String[]{"assertStringContainsString", "assertStringNotContainsString", "assertStringContainsStringIgnoringCase", "assertStringNotContainsStringIgnoringCase"});

    @Override
    protected boolean isSupportedAssertType(@NotNull AssertType assertType) {
        if (assertType == null) {
            PhpUnitAssertContainsInspection.$$$reportNull$$$0(0);
        }
        return assertType == AssertType.ASSERT_CONTAINS || assertType == AssertType.ASSERT_NOT_CONTAINS;
    }

    @Override
    protected Set<String> getSpecializedAssertMethodNames() {
        return SPECIALIZED_ASSERT_METHOD_NAMES;
    }

    @Override
    protected void declareProblemType(@NotNull MethodReference methodReference, @NotNull ProblemsHolder holder, @NotNull AssertType assertType) {
        if (methodReference == null) {
            PhpUnitAssertContainsInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpUnitAssertContainsInspection.$$$reportNull$$$0(2);
        }
        if (assertType == null) {
            PhpUnitAssertContainsInspection.$$$reportNull$$$0(3);
        }
        PhpTypedElement needle = (PhpTypedElement)ObjectUtils.tryCast((Object)PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(methodReference, 0), PhpTypedElement.class);
        PhpTypedElement haystack = (PhpTypedElement)ObjectUtils.tryCast((Object)PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(methodReference, 1), PhpTypedElement.class);
        if (needle != null && haystack != null && PhpUnitAssertContainsInspection.isString(needle) && PhpUnitAssertContainsInspection.isString(haystack)) {
            super.declareProblemType(methodReference, holder, assertType);
        }
    }

    private static boolean isString(PhpTypedElement element) {
        return element.getGlobalType().equals((Object)PhpType.STRING);
    }

    @Override
    protected boolean suitableNumberOfParameters(PsiElement[] parameters) {
        return parameters.length > 0;
    }

    @Override
    @NotNull
    protected Stream<AssertParameter> possibleNonDefaultParameters() {
        StreamEx streamEx = StreamEx.of((Object)((Object)AssertParameter.IGNORE_CASE));
        if (streamEx == null) {
            PhpUnitAssertContainsInspection.$$$reportNull$$$0(4);
        }
        return streamEx;
    }

    @Override
    protected int getParameterIndex(AssertParameter assertParameter) {
        return assertParameter.ordinal();
    }

    @Override
    @Nullable
    protected LocalQuickFix getAssertEqualsQuickFix(@NotNull Set<AssertParameter> nonDefaultParametersSet, @NotNull AssertType assertType) {
        if (nonDefaultParametersSet == null) {
            PhpUnitAssertContainsInspection.$$$reportNull$$$0(5);
        }
        if (assertType == null) {
            PhpUnitAssertContainsInspection.$$$reportNull$$$0(6);
        }
        String newMethodName = PhpUnitAssertContainsInspection.addStringPartsToName(assertType.toString());
        if (nonDefaultParametersSet.isEmpty()) {
            return new PhpUnitDropOptionalParametersQuickFix(newMethodName, PhpBundle.message("quickfix.phpunit.replace.current.method.with.alternative", newMethodName));
        }
        if (ContainerUtil.getOnlyItem(nonDefaultParametersSet) == AssertParameter.IGNORE_CASE) {
            return new PhpUnitReplaceAssertMethodReferenceQuickFix(newMethodName + AssertParameter.IGNORE_CASE.getMethodNameSuffix(), 3);
        }
        return null;
    }

    private static String addStringPartsToName(String methodName) {
        return methodName.startsWith("assertNot") ? "assertStringNotContainsString" : "assertStringContainsString";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertContainsInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonDefaultParametersSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertContainsInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "possibleNonDefaultParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedAssertType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "declareProblemType";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAssertEqualsQuickFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

