/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AssertType {
    ASSERT_EQUALS("assertEquals"),
    ASSERT_NOT_EQUALS("assertNotEquals"),
    ASSERT_FILE_EQUALS("assertFileEquals"),
    ASSERT_FILE_NOT_EQUALS("assertFileNotEquals"),
    ASSERT_STRING_EQUALS_FILE("assertStringEqualsFile"),
    ASSERT_STRING_NOT_EQUALS_FILE("assertStringNotEqualsFile"),
    ASSERT_CONTAINS("assertContains"),
    ASSERT_NOT_CONTAINS("assertNotContains");

    @NotNull
    public static final Set<AssertType> EQUALS_TYPES;
    private final String value;

    private AssertType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @Nullable
    public static AssertType getAssertType(@NotNull MethodReference methodReference) {
        if (methodReference == null) {
            AssertType.$$$reportNull$$$0(0);
        }
        String methodName = methodReference.getName();
        return StreamEx.of((Object[])AssertType.values()).findFirst(value -> StringUtil.equalsIgnoreCase((CharSequence)methodName, (CharSequence)value.value)).orElse(null);
    }

    static {
        EQUALS_TYPES = ContainerUtil.set((Object[])new AssertType[]{ASSERT_EQUALS, ASSERT_NOT_EQUALS});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReference", "com/jetbrains/php/lang/inspections/phpunit/AssertType", "getAssertType"));
    }
}

