/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpChangeFunctionSignatureFromUsageQuickFix;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureDialog;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUpdateSignatureFromPhpDocQuickFix
implements LocalQuickFix,
IntentionAction {
    private static final PhpParameterInfo[] EMPTY_ARRAY = new PhpParameterInfo[0];
    @Nls
    public static final String FIX_NAME = PhpBundle.message("update.signature.to.match.phpdoc.comment", new Object[0]);

    @NotNull
    public static PhpParameterInfo createParameterInfo(Function function, Parameter[] parameters, PhpDocParamTag tag) {
        Parameter parameter = (Parameter)ContainerUtil.find((Object[])parameters, p -> p.getDocTag() == tag);
        PhpParameterInfo parameterInfo = PhpUpdateSignatureFromPhpDocQuickFix.createParameterInfo(parameters, parameter, tag);
        PhpType newType = PhpUpdateSignatureFromPhpDocQuickFix.getNewType((PhpDocTag)tag);
        PhpType defaultValueType = PhpUpdateSignatureFromPhpDocQuickFix.getDefaultValueType(parameter);
        if (tag.isVariadic()) {
            newType = newType.unpluralize();
            defaultValueType = PhpType.EMPTY;
        }
        if (parameter != null) {
            parameterInfo.setInitializer(PhpUpdateSignatureFromPhpDocQuickFix.getNewDefaultValue(parameter, newType, defaultValueType));
            parameterInfo.setIsPassByRef(parameter.isPassByRef());
        }
        if (tag.getType().isNullable() && !PhpProjectConfigurationFacade.getInstance(tag.getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.NULLABLES)) {
            parameterInfo.setType(PhpType.EMPTY, "");
        } else {
            parameterInfo.setType(newType, PhpUpdateSignatureFromPhpDocQuickFix.getTypeString((PsiElement)function, newType, defaultValueType));
        }
        parameterInfo.setVariadic(tag.isVariadic());
        PhpParameterInfo phpParameterInfo = parameterInfo;
        if (phpParameterInfo == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(0);
        }
        return phpParameterInfo;
    }

    @NotNull
    private static String getNewDefaultValue(@NotNull Parameter parameter, @NotNull PhpType newType, @NotNull PhpType defaultValueType) {
        if (parameter == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(1);
        }
        if (newType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(2);
        }
        if (defaultValueType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(3);
        }
        if (PhpType.isSubType((PhpType)defaultValueType, (PhpType)newType) || PhpDocSignatureInspection.typesMatch(parameter.getProject(), defaultValueType, newType)) {
            String string = Optional.ofNullable(parameter.getDefaultValue()).map(d -> d.getText()).orElse("");
            if (string == null) {
                PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }
        return "";
    }

    @NotNull
    private static PhpType getDefaultValueType(@Nullable Parameter parameter) {
        PhpType phpType = parameter != null ? new PhpType().add(parameter.getDefaultValue()) : PhpType.EMPTY;
        if (phpType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(5);
        }
        return phpType;
    }

    @NotNull
    public static PhpParameterInfo createParameterInfo(Parameter[] parameters, Parameter parameter, PhpDocParamTag tag) {
        if (parameter != null) {
            return new PhpParameterInfo(ArrayUtil.indexOf((Object[])parameters, (Object)parameter), parameter);
        }
        return new PhpParameterInfo(-1, tag.getVarName());
    }

    @Nullable
    public static String getParameterTypeString(Function function, PhpDocTag tag) {
        Parameter parameter = (Parameter)ContainerUtil.find((Object[])function.getParameters(), p -> p.getDocTag() == tag);
        PhpType defaultValueType = PhpUpdateSignatureFromPhpDocQuickFix.getDefaultValueType(parameter);
        PhpType type = PhpUpdateSignatureFromPhpDocQuickFix.getNewType(tag);
        return StringUtil.nullize((String)PhpUpdateSignatureFromPhpDocQuickFix.getTypeString((PsiElement)function, type, defaultValueType));
    }

    @NotNull
    public static String getTypeString(@NotNull PsiElement place, @NotNull PhpType type, @NotNull PhpType defaultValueType) {
        if (place == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(6);
        }
        if (type == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(7);
        }
        if (defaultValueType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(8);
        }
        boolean isUnionTypeSupported = PhpLanguageFeature.UNION_TYPES.isSupported(place.getProject());
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(place);
        PhpType typeWithoutDefaultValue = PhpType.NULL.equals((Object)defaultValueType) ? type.filterNull() : type;
        String string = PhpAddMethodDeclarationQuickFix.createParameterTypeHint(place.getProject(), typeWithoutDefaultValue, scope, false, isUnionTypeSupported);
        if (string == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static PhpType getNewType(@NotNull PhpDocTag tag) {
        if (tag == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(10);
        }
        PhpType phpType = PhpAddMethodDeclarationQuickFix.collectSuitableForParameterTypeHint(tag.getProject(), tag.getGlobalType());
        if (phpType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(11);
        }
        return phpType;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = FIX_NAME;
        if (string == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(14);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(15);
        }
        this.doInvoke(editor, file.findElementAt(editor.getCaretModel().getOffset()));
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(16);
        }
        if (descriptor == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(17);
        }
        PsiElement element = descriptor.getStartElement();
        this.doInvoke(null, element);
    }

    private void doInvoke(@Nullable Editor editor, PsiElement element) {
        PhpDocComment docComment = PhpUpdateSignatureFromPhpDocQuickFix.getDocComment(element);
        if (docComment == null) {
            return;
        }
        Function function = (Function)ObjectUtils.tryCast((Object)docComment.getOwner(), Function.class);
        if (function == null) {
            return;
        }
        List<PhpParameterInfo> parametersInfo = this.createParametersInfosFromDocComment(function);
        if (parametersInfo == null) {
            return;
        }
        PhpChangeInfo changeInfo = this.createChangeInfo(docComment, function, parametersInfo);
        PhpUpdateSignatureFromPhpDocQuickFix.changeFunctionSignature(function, changeInfo, editor == null);
    }

    public static void changeFunctionSignature(@NotNull Function function, @NotNull PhpChangeInfo changeInfo, boolean isOnFly) {
        Collection<UsageInfo> usages;
        if (function == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(18);
        }
        if (changeInfo == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(19);
        }
        if ((usages = PhpChangeFunctionSignatureFromUsageQuickFix.getUsages(function.getProject(), changeInfo)) == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            MultiMap conflicts = MultiMap.create();
            ChangeSignatureProcessorBase.collectConflictsFromExtensions((Ref)new Ref((Object)usages.toArray(UsageInfo.EMPTY_ARRAY)), (MultiMap)conflicts, (ChangeInfo)changeInfo);
            if (!conflicts.isEmpty()) {
                throw new RuntimeException(String.join((CharSequence)", ", conflicts.values()));
            }
        }
        if (usages.isEmpty() || !changeInfo.isParameterSetOrOrderChanged()) {
            if (PhpUpdateSignatureFromPhpDocQuickFix.prepareFilesForWriting(function, usages)) {
                WriteAction.run(() -> ChangeSignatureProcessorBase.doChangeSignature((ChangeInfo)changeInfo, (UsageInfo[])usages.toArray(UsageInfo.EMPTY_ARRAY)));
            }
            return;
        }
        if (!isOnFly) {
            PhpChangeSignatureDialog dialog = new PhpChangeSignatureDialog(function.getProject(), new PhpMethodDescriptor(function), (PsiElement)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)ParameterList.INSTANCEOF));
            dialog.setParameterInfos(Arrays.asList(changeInfo.getNewParameters()));
            dialog.show();
        }
    }

    private static boolean prepareFilesForWriting(@NotNull Function function, @NotNull Collection<UsageInfo> usages) {
        if (function == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(20);
        }
        if (usages == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(21);
        }
        return FileModificationService.getInstance().prepareFileForWrite(function.getContainingFile()) && usages.stream().map(u -> u.getElement()).filter(Objects::nonNull).map(e -> e.getContainingFile()).filter(Objects::nonNull).distinct().allMatch(f -> FileModificationService.getInstance().prepareFileForWrite(f));
    }

    private static PhpDocComment getDocComment(PsiElement element) {
        PhpDocComment docComment = (PhpDocComment)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF);
        if (docComment != null) {
            return docComment;
        }
        Function function = (Function)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)Function.INSTANCEOF);
        if (function == null) {
            return null;
        }
        return function.getDocComment();
    }

    @Nullable
    public List<PhpParameterInfo> createParametersInfosFromDocComment(Function function) {
        Parameter[] parameters = function.getParameters();
        PhpDocComment comment = function.getDocComment();
        if (comment == null) {
            return null;
        }
        return ContainerUtil.map((Collection)comment.getParamTags(), tag -> PhpUpdateSignatureFromPhpDocQuickFix.createParameterInfo(function, parameters, tag));
    }

    @NotNull
    public PhpChangeInfo createChangeInfo(PhpDocComment docComment, Function function, List<PhpParameterInfo> parametersInfo) {
        PhpMethodDescriptor methodDescriptor = new PhpMethodDescriptor(function);
        PhpDocReturnTag tag = docComment.getReturnTag();
        String returnTypeText = this.getReturnTypeText(function, methodDescriptor, tag);
        return new PhpChangeInfo(methodDescriptor, parametersInfo.toArray(EMPTY_ARRAY), methodDescriptor.getVisibility(), methodDescriptor.getName(), returnTypeText, null, false, false);
    }

    @Nullable
    protected String getReturnTypeText(Function function, PhpMethodDescriptor originalMethodDescriptor, PhpDocReturnTag tag) {
        if (tag == null) {
            return originalMethodDescriptor.getReturnTypeText();
        }
        PhpType newType = PhpUpdateSignatureFromPhpDocQuickFix.getReturnType(tag);
        return StringUtil.nullize((String)PhpUpdateSignatureFromPhpDocQuickFix.getTypeString((PsiElement)function, newType, PhpType.EMPTY));
    }

    @NotNull
    private static PhpType getReturnType(@NotNull PhpDocReturnTag tag) {
        if (tag == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(22);
        }
        List phpDocTypes = (List)StreamEx.of((Object[])tag.getChildren()).select(PhpDocType.class).collect(Collectors.toList());
        PhpType result = new PhpType();
        boolean isMixedTypeHintSupported = PhpLanguageFeature.MIXED_TYPE_HINT.isSupported(tag.getProject());
        boolean isStaticTypeHintSupported = PhpLanguageFeature.STATIC_RETURN_TYPE_HINT.isSupported(tag.getProject());
        boolean isObjectTypeHintSupported = PhpLanguageFeature.OBJECT_TYPE_HINT.isSupported(tag.getProject());
        for (PhpDocType docType : phpDocTypes) {
            if (isMixedTypeHintSupported && PhpType.intersects((PhpType)docType.getType(), (PhpType)PhpType.MIXED)) {
                PhpType phpType = PhpType.MIXED;
                if (phpType == null) {
                    PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(23);
                }
                return phpType;
            }
            if (isObjectTypeHintSupported && PhpType.intersects((PhpType)docType.getType(), (PhpType)PhpType.OBJECT)) {
                result.add(PhpType.OBJECT);
                continue;
            }
            if (isStaticTypeHintSupported && "static".equalsIgnoreCase(docType.getText())) {
                result.add("static");
                continue;
            }
            if ("self".equalsIgnoreCase(docType.getText()) || "parent".equalsIgnoreCase(docType.getText())) {
                result.add(docType.getText());
                continue;
            }
            result.add(docType.getGlobalType().filterUnknown());
        }
        PhpType phpType = result;
        if (phpType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(24);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpUpdateSignatureFromPhpDocQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValueType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeInfo";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpUpdateSignatureFromPhpDocQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewDefaultValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNewDefaultValue";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNewType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "changeFunctionSignature";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "prepareFilesForWriting";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

