/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.google.common.collect.Sets;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocFieldTypeMismatchInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.impl.PhpFieldTypeImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PhpUpdateFieldTypeFromPhpDocQuickFix
extends PhpQuickFixBase {
    private static final Collection<PhpType> NOT_SUPPORTED_TYPES = Sets.newHashSet((Object[])new PhpType[]{PhpType.NULL, PhpType.VOID, PhpType.FALSE, PhpType.CALLABLE, PhpType.RESOURCE});
    private final String myDocTypePresentation;

    public PhpUpdateFieldTypeFromPhpDocQuickFix(@NotNull String docTypePresentation) {
        if (docTypePresentation == null) {
            PhpUpdateFieldTypeFromPhpDocQuickFix.$$$reportNull$$$0(0);
        }
        this.myDocTypePresentation = docTypePresentation;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.phpdoc.update.field.type", this.myDocTypePresentation);
        if (string == null) {
            PhpUpdateFieldTypeFromPhpDocQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean isSupported(@NotNull PhpType docType) {
        if (docType == null) {
            PhpUpdateFieldTypeFromPhpDocQuickFix.$$$reportNull$$$0(2);
        }
        return !NOT_SUPPORTED_TYPES.contains(docType) && !PhpType.intersects((PhpType)docType, (PhpType)PhpType.VOID);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PhpDocParamTag varTag;
        if (project == null) {
            PhpUpdateFieldTypeFromPhpDocQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            PhpUpdateFieldTypeFromPhpDocQuickFix.$$$reportNull$$$0(4);
        }
        if ((varTag = (PhpDocParamTag)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PhpDocParamTag.class)) == null) {
            return;
        }
        Field field = PhpDocFieldTypeMismatchInspection.getTagOwner(varTag);
        PhpFieldTypeImpl actualType = (PhpFieldTypeImpl)PsiTreeUtil.getPrevSiblingOfType((PsiElement)field, PhpFieldTypeImpl.class);
        if (actualType == null) {
            return;
        }
        actualType.update(varTag.getType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTypePresentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpUpdateFieldTypeFromPhpDocQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpUpdateFieldTypeFromPhpDocQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

