/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.UpdatePhpDocTypeQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.MethodImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpReturnDocTypeMismatchInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpReturnDocTypeMismatchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                super.visitPhpFunction(function);
                PhpReturnDocTypeMismatchInspection.checkPhpFunction(function, holder);
            }

            public void visitPhpMethod(Method method) {
                super.visitPhpMethod(method);
                PhpReturnDocTypeMismatchInspection.checkPhpFunction((Function)method, holder);
            }
        };
    }

    private static void checkPhpFunction(Function function, @NotNull ProblemsHolder holder) {
        PhpDocComment docComment;
        if (holder == null) {
            PhpReturnDocTypeMismatchInspection.$$$reportNull$$$0(1);
        }
        if ((docComment = function.getDocComment()) == null) {
            return;
        }
        PhpDocReturnTag docReturnTag = docComment.getReturnTag();
        if (docReturnTag == null) {
            return;
        }
        Project project = function.getProject();
        PhpType docType = docReturnTag.getDocType().global(project);
        if (docType.isEmpty()) {
            return;
        }
        if (function.getTypeDeclaration() != null) {
            return;
        }
        PhpType functionInferredType = function.getInferredType().global(project);
        PhpType compatibleWithInferredType = PhpReturnDocTypeMismatchInspection.getCompatibleType(project, docType, functionInferredType);
        if (docType.equals((Object)compatibleWithInferredType)) {
            return;
        }
        PhpType inferredType = PhpType.or((PhpType)functionInferredType, (PhpType)PhpReturnDocTypeMismatchInspection.getInferredTypeOfOverriddenMethods(function));
        PhpType compatibleType = PhpReturnDocTypeMismatchInspection.getCompatibleType(project, docType, inferredType);
        if (!docType.equals((Object)compatibleType)) {
            ArrayList<UpdatePhpDocTypeQuickFix> quickFixes = new ArrayList<UpdatePhpDocTypeQuickFix>();
            if (PhpType.NULL.equals((Object)inferredType)) {
                if (docType.isNullable() || PhpType.intersects((PhpType)docType, (PhpType)PhpType.MIXED)) {
                    return;
                }
                quickFixes.add(new UpdatePhpDocTypeQuickFix(PhpType.or((PhpType)docType, (PhpType)PhpType.NULL), project, (PhpPsiElement)function));
            } else {
                quickFixes.add(new UpdatePhpDocTypeQuickFix(inferredType, project, (PhpPsiElement)function));
            }
            if (!compatibleType.filterNull().isEmpty()) {
                quickFixes.add(new UpdatePhpDocTypeQuickFix(compatibleType, project, (PhpPsiElement)function));
            }
            PhpReturnDocTypeMismatchInspection.registerProblem(docReturnTag, holder, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private static PhpType getInferredTypeOfOverriddenMethods(@NotNull Function function) {
        MethodImpl method;
        if (function == null) {
            PhpReturnDocTypeMismatchInspection.$$$reportNull$$$0(2);
        }
        if ((method = (MethodImpl)ObjectUtils.tryCast((Object)function, MethodImpl.class)) == null) {
            return PhpType.EMPTY;
        }
        Ref result = new Ref((Object)new PhpType());
        PhpClassHierarchyUtils.processOverridingMethods((Method)method, (member, subClass, baseClass) -> {
            result.set((Object)PhpType.or((PhpType)((PhpType)result.get()), (PhpType)member.getInferredType().global(member.getProject())));
            return true;
        });
        return ((PhpType)result.get()).global(function.getProject());
    }

    @NotNull
    private static PhpType getCompatibleType(@NotNull Project project, @NotNull PhpType type, @NotNull PhpType inferredType) {
        if (project == null) {
            PhpReturnDocTypeMismatchInspection.$$$reportNull$$$0(3);
        }
        if (type == null) {
            PhpReturnDocTypeMismatchInspection.$$$reportNull$$$0(4);
        }
        if (inferredType == null) {
            PhpReturnDocTypeMismatchInspection.$$$reportNull$$$0(5);
        }
        if (inferredType.isAmbiguous()) {
            PhpType phpType = type;
            if (phpType == null) {
                PhpReturnDocTypeMismatchInspection.$$$reportNull$$$0(6);
            }
            return phpType;
        }
        if (inferredType.isEmpty() && !PhpType.intersects((PhpType)type, (PhpType)PhpType.VOID)) {
            PhpType phpType = type;
            if (phpType == null) {
                PhpReturnDocTypeMismatchInspection.$$$reportNull$$$0(7);
            }
            return phpType;
        }
        PhpType phpType = type.getTypes().stream().map(t -> PhpType.builder().add(t).build()).filter(t -> PhpType.NULL.equals(t) || PhpStrictTypeCheckingInspection.isTypeCompatible(t, inferredType)).filter(t -> t.isConvertibleFrom(inferredType, PhpIndex.getInstance((Project)project))).filter(t -> !PhpType.MIXED.equals(t)).reduce(new PhpType(), (acc, t) -> acc.add(t));
        if (phpType == null) {
            PhpReturnDocTypeMismatchInspection.$$$reportNull$$$0(8);
        }
        return phpType;
    }

    private static void registerProblem(@NotNull PhpDocReturnTag docReturnTag, @NotNull ProblemsHolder holder, LocalQuickFix ... fixes) {
        if (docReturnTag == null) {
            PhpReturnDocTypeMismatchInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            PhpReturnDocTypeMismatchInspection.$$$reportNull$$$0(10);
        }
        List<PhpDocType> docTypeElements = Arrays.asList((PhpDocType[])PsiTreeUtil.getChildrenOfType((PsiElement)docReturnTag, PhpDocType.class));
        PsiElement firstDocTypeElement = (PsiElement)ContainerUtil.getFirstItem(docTypeElements);
        PsiElement lastDocTypeElement = (PsiElement)ContainerUtil.getLastItem(docTypeElements);
        if (firstDocTypeElement == null || lastDocTypeElement == null) {
            return;
        }
        ProblemDescriptorImpl problemDescriptor = new ProblemDescriptorImpl(firstDocTypeElement, lastDocTypeElement, PhpBundle.message("inspection.php.return.doc.type.mismatch", new Object[0]), fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, holder.isOnTheFly());
        holder.registerProblem((ProblemDescriptor)problemDescriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpReturnDocTypeMismatchInspection";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docReturnTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpReturnDocTypeMismatchInspection";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkPhpFunction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInferredTypeOfOverriddenMethods";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibleType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

